/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class StackRefreshClientMessage {
    private final int size;
    private final int csize;
    private final List<ItemStack> stacks;
    private final List<ItemStack> craftableStacks;

    public StackRefreshClientMessage(List<ItemStack> stacks, List<ItemStack> craftableStacks) {
        this.stacks = stacks;
        this.craftableStacks = craftableStacks;
        this.size = stacks.size();
        this.csize = craftableStacks.size();
    }

    public static void handle(StackRefreshClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof IGuiNetwork) {
                IGuiNetwork gui = (IGuiNetwork)mc.f_91080_;
                gui.setStacks(message.stacks);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(StackRefreshClientMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.size);
        buf.writeInt(msg.csize);
        for (ItemStack stack : msg.stacks) {
            buf.m_130079_(stack.serializeNBT());
            buf.writeInt(stack.m_41613_());
        }
        for (ItemStack stack : msg.craftableStacks) {
            buf.m_130079_(stack.serializeNBT());
            buf.writeInt(stack.m_41613_());
        }
    }

    public static StackRefreshClientMessage decode(FriendlyByteBuf buf) {
        ItemStack stack;
        int size = buf.readInt();
        int csize = buf.readInt();
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            CompoundTag stacktag = buf.m_130260_();
            stack = ItemStack.m_41712_((CompoundTag)stacktag);
            stack.m_41764_(buf.readInt());
            stacks.add(stack);
        }
        ArrayList craftableStacks = Lists.newArrayList();
        for (int i = 0; i < csize; ++i) {
            stack = ItemStack.m_41712_((CompoundTag)buf.m_130260_());
            stack.m_41764_(buf.readInt());
            craftableStacks.add(stack);
        }
        return new StackRefreshClientMessage(stacks, craftableStacks);
    }
}

