/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.collection;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.block.collection.ContainerCollectionFilter;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.CableIOMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiCollectionFilter
extends ContainerScreen<ContainerCollectionFilter>
implements IGuiPrivate {
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/plain_filter.png");
    ContainerCollectionFilter containerCableLink;
    private List<ItemSlotNetwork> itemSlotsGhost;
    public static final int SLOT_SIZE = 18;

    public GuiCollectionFilter(ContainerCollectionFilter containerCableFilter, PlayerInventory inv, ITextComponent name) {
        super((Container)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    @Override
    public void renderStackTooltip(MatrixStack ms, ItemStack stack, int mousex, int mousey) {
        super.func_230457_a_(ms, stack, mousex, mousey);
    }

    @Override
    public void drawGradient(MatrixStack ms, int x, int y, int x2, int y2, int u, int v) {
        super.func_238468_a_(ms, x, y, x2, y2, u, v);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
    }

    public void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.texture);
        int xCenter = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yCenter = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(ms, xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 35;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, stack.func_190916_E(), this.field_147003_i, this.field_147009_r, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(ms, this.field_230712_o_, mouseX, mouseY);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        ItemStack mouse = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().func_190926_b()) {
                if (mouseButton == 1) {
                    int direction = GuiCollectionFilter.func_231173_s_() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().func_190916_E() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().func_190920_e(newCount);
                } else {
                    slot.setStack(ItemStack.field_190927_a);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            ItemStack cpy = mouse.func_77946_l();
            cpy.func_190920_e(1);
            slot.setStack(cpy);
            this.sendStackSlot(i, cpy);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY);
    }
}

