/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability;

import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.capability.handler.UpgradesItemStackHandler;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableAutoIO
implements INBTSerializable<CompoundNBT>,
IConnectableItemAutoIO {
    public final IConnectable connectable;
    public EnumStorageDirection direction;
    public final UpgradesItemStackHandler upgrades = new UpgradesItemStackHandler();
    private final FilterItemStackHandler filters = new FilterItemStackHandler();
    private ItemStack operationStack = ItemStack.field_190927_a;
    private int operationLimit = 0;
    private boolean operationMustBeSmaller = true;
    private int priority = 0;
    private Direction inventoryFace;
    private boolean needsRedstone = false;

    CapabilityConnectableAutoIO(EnumStorageDirection direction) {
        this.connectable = new CapabilityConnectable();
        this.direction = direction;
    }

    @Override
    public void toggleNeedsRedstone() {
        this.needsRedstone = !this.needsRedstone;
    }

    @Override
    public boolean needsRedstone() {
        return this.needsRedstone;
    }

    @Override
    public void needsRedstone(boolean in) {
        this.needsRedstone = in;
    }

    public FilterItemStackHandler getFilter() {
        return this.filters;
    }

    public List<ItemStack> getStoredStacks(boolean isFiltered) {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b() || isFiltered && this.filters.isStackFiltered(stack)) continue;
            result.add(stack.func_77946_l());
        }
        return result;
    }

    public void setPriority(int value) {
        this.priority = value;
    }

    public void setFilter(int value, ItemStack stack) {
        this.filters.setStackInSlot(value, stack);
        this.filters.getStacks().set(value, stack);
    }

    public CapabilityConnectableAutoIO(TileEntity tile, EnumStorageDirection direction) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
        this.direction = direction;
        if (direction == EnumStorageDirection.OUT) {
            this.filters.setIsAllowlist(true);
        } else {
            this.filters.setIsAllowlist(false);
        }
    }

    public void setInventoryFace(Direction inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT result = new CompoundNBT();
        result.func_218657_a("upgrades", (INBT)this.upgrades.serializeNBT());
        result.func_218657_a("filters", (INBT)this.filters.serializeNBT());
        CompoundNBT operation = new CompoundNBT();
        operation.func_218657_a("stack", (INBT)this.operationStack.serializeNBT());
        operation.func_74757_a("mustBeSmaller", this.operationMustBeSmaller);
        operation.func_74768_a("limit", this.operationLimit);
        result.func_218657_a("operation", (INBT)operation);
        result.func_74768_a("prio", this.priority);
        if (this.inventoryFace != null) {
            result.func_74778_a("inventoryFace", this.inventoryFace.toString());
        }
        result.func_74757_a("needsRedstone", this.needsRedstone());
        return result;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        CompoundNBT filters;
        CompoundNBT upgrades = nbt.func_74775_l("upgrades");
        if (upgrades != null) {
            this.upgrades.deserializeNBT(upgrades);
        }
        if ((filters = nbt.func_74775_l("filters")) != null) {
            this.filters.deserializeNBT(filters);
        }
        CompoundNBT operation = nbt.func_74775_l("operation");
        this.operationStack = ItemStack.field_190927_a;
        if (operation != null) {
            this.operationLimit = operation.func_74762_e("limit");
            this.operationMustBeSmaller = operation.func_74767_n("mustBeSmaller");
            if (operation.func_150297_b("stack", 10)) {
                this.operationStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)operation.func_74781_a("stack")));
            }
        }
        this.priority = nbt.func_74762_e("prio");
        if (nbt.func_74764_b("inventoryFace")) {
            this.inventoryFace = Direction.func_176739_a((String)nbt.func_74779_i("inventoryFace"));
        }
        this.needsRedstone(nbt.func_74767_n("needsRedstone"));
    }

    @Override
    public EnumStorageDirection ioDirection() {
        return this.direction;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getTransferRate() {
        return this.upgrades.getUpgradesOfType(SsnRegistry.STACK_UPGRADE) > 0 ? 64 : 4;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.direction == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
    }

    public List<ItemStack> getStacksForFilter() {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b() || this.filters.exactStackAlreadyInList(stack)) continue;
            result.add(stack.func_77946_l());
            if (result.size() < 18) continue;
            return result;
        }
        return result;
    }

    @Override
    public ItemStack extractNextStack(int size, boolean simulate) {
        if (this.direction == EnumStorageDirection.OUT) {
            return ItemStack.field_190927_a;
        }
        if (this.inventoryFace == null) {
            return ItemStack.field_190927_a;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b() || this.filters.isStackFiltered(stack)) continue;
            int extractSize = Math.min(size, stack.func_190916_E());
            return itemHandler.extractItem(slot, extractSize, simulate);
        }
        return ItemStack.field_190927_a;
    }

    private int countOps() {
        return 0;
    }

    private boolean doesPassOperationFilterLimit(TileMain root) {
        if (this.countOps() < 1) {
            return true;
        }
        if (this.operationStack == null || this.operationStack.func_190926_b()) {
            return true;
        }
        int availableStack = root.getAmount(new ItemStackMatcher(this.operationStack, this.filters.tags, this.filters.nbt));
        if (this.operationMustBeSmaller) {
            return this.operationLimit >= availableStack;
        }
        return this.operationLimit < availableStack;
    }

    @Override
    public boolean runNow(DimPos connectablePos, TileMain main) {
        int speed = Math.max(this.upgrades.getUpgradesOfType(SsnRegistry.SPEED_UPGRADE) + 1, 1);
        int speedRatio = 30 / speed;
        if (speedRatio <= 1) {
            speedRatio = 1;
        }
        boolean cooldownOk = connectablePos.getWorld().func_82737_E() % (long)speedRatio == 0L;
        boolean operationLimitOk = this.doesPassOperationFilterLimit(main);
        return cooldownOk && operationLimitOk;
    }

    @Override
    public List<IItemStackMatcher> getAutoExportList() {
        return this.filters.getStackMatchers();
    }

    @Override
    public boolean isStockMode() {
        return false;
    }

    @Override
    public Direction facingInventory() {
        return this.inventoryFace;
    }

    public static class Storage
    implements Capability.IStorage<IConnectableItemAutoIO> {
        @Nullable
        public INBT writeNBT(Capability<IConnectableItemAutoIO> capability, IConnectableItemAutoIO rawInstance, Direction side) {
            CapabilityConnectableAutoIO instance = (CapabilityConnectableAutoIO)rawInstance;
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IConnectableItemAutoIO> capability, IConnectableItemAutoIO rawInstance, Direction side, INBT nbt) {
            CapabilityConnectableAutoIO instance = (CapabilityConnectableAutoIO)rawInstance;
            instance.deserializeNBT((CompoundNBT)nbt);
        }
    }

    public static class Factory
    implements Callable<IConnectableItemAutoIO> {
        @Override
        public IConnectableItemAutoIO call() throws Exception {
            return new CapabilityConnectableAutoIO(EnumStorageDirection.IN);
        }
    }
}

