/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.NetworkCraftingInventory;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class ContainerNetwork
extends Container {
    protected final CraftResultInventory resultInventory = new CraftResultInventory();
    protected PlayerInventory playerInv;
    protected CraftingResultSlot result;
    protected boolean recipeLocked = false;
    protected PlayerEntity player;
    protected World world;
    protected ICraftingRecipe recipeCurrent;
    public NetworkCraftingInventory matrix;

    public abstract TileMain getTileMain();

    public abstract void slotChanged();

    protected ContainerNetwork(@Nullable ContainerType<?> type, int id) {
        super(type, id);
    }

    @Nullable
    public CraftingInventory getCraftMatrix() {
        return this.matrix;
    }

    protected void bindPlayerInvo(PlayerInventory playerInv) {
        this.player = playerInv.field_70458_d;
        this.world = this.player.field_70170_p;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 174 + i * 18));
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        if (!this.isCrafting()) {
            return super.func_94530_a(stack, slot);
        }
        return slot.field_75224_c != this.result && super.func_94530_a(stack, slot);
    }

    public void bindHotbar() {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInv, i, 8 + i * 18, 232));
        }
    }

    protected void bindGrid() {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.matrix, index++, 8 + j * 18, 110 + i * 18));
            }
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.slotChanged();
        super.func_75134_a(playerIn);
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        super.func_75130_a(inventoryIn);
        this.recipeCurrent = null;
        this.findMatchingRecipe(this.field_75152_c, this.world, this.player, this.matrix, this.resultInventory);
    }

    protected void findMatchingRecipeClient(World world, CraftingInventory inventory, CraftResultInventory result) {
        Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
        if (optional.isPresent()) {
            ICraftingRecipe icraftingrecipe;
            this.recipeCurrent = icraftingrecipe = (ICraftingRecipe)optional.get();
        }
    }

    private void findMatchingRecipe(int number, World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory result) {
        if (!world.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (optional.isPresent() && result.func_201561_a(world, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)inventory);
                this.recipeCurrent = icraftingrecipe;
            }
            result.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(number, 0, itemstack));
        }
    }

    public abstract boolean isCrafting();

    public ItemStack func_82846_b(PlayerEntity playerIn, int slotIndex) {
        if (playerIn.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            TileMain tileMain = this.getTileMain();
            if (this.isCrafting() && slotIndex == 0) {
                this.craftShift(playerIn, tileMain);
                return ItemStack.field_190927_a;
            }
            if (tileMain != null) {
                int rest = tileMain.insertStack(itemstack1, false);
                ItemStack stack = rest == 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)rest);
                slot.func_75215_d(stack);
                this.func_75142_b();
                List<ItemStack> list = tileMain.getStacks();
                if (playerIn instanceof ServerPlayerEntity) {
                    ServerPlayerEntity sp = (ServerPlayerEntity)playerIn;
                    PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), sp.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected void craftShift(PlayerEntity player, TileMain tile) {
        if (!this.isCrafting() || this.matrix == null || tile == null) {
            return;
        }
        this.recipeCurrent = null;
        this.findMatchingRecipeClient(player.field_70170_p, this.matrix, this.resultInventory);
        if (this.recipeCurrent == null) {
            return;
        }
        this.recipeLocked = true;
        int crafted = 0;
        ArrayList recipeCopy = Lists.newArrayList();
        for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
            recipeCopy.add(this.matrix.func_70301_a(i).func_77946_l());
        }
        ItemStack res = this.recipeCurrent.func_77572_b((IInventory)this.matrix);
        if (res.func_190926_b()) {
            StorageNetwork.LOGGER.error("err Recipe output is an empty stack " + this.recipeCurrent);
            return;
        }
        int sizePerCraft = res.func_190916_E();
        while (crafted + sizePerCraft <= res.func_77976_d() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInv), (ItemStack)(res = this.recipeCurrent.func_77572_b((IInventory)this.matrix)), (boolean)true).func_190926_b() && this.recipeCurrent.func_77569_a((IInventory)this.matrix, player.field_70170_p)) {
            if (!player.field_71071_by.func_70441_a(res)) {
                player.func_71019_a(res, false);
            }
            NonNullList remainder = this.recipeCurrent.func_179532_b((IInventory)this.matrix);
            for (int i = 0; i < remainder.size(); ++i) {
                ItemStack remainderCurrent = (ItemStack)remainder.get(i);
                ItemStack slot = this.matrix.func_70301_a(i);
                if (remainderCurrent.func_190926_b()) {
                    this.matrix.func_70301_a(i).func_190918_g(1);
                    continue;
                }
                if (slot.func_77973_b().func_77668_q() != null) {
                    slot = new ItemStack((IItemProvider)slot.func_77973_b().func_77668_q());
                    this.matrix.func_70299_a(i, slot);
                    continue;
                }
                if (!slot.func_77973_b().getContainerItem(slot).func_190926_b()) {
                    slot = slot.func_77973_b().getContainerItem(slot);
                    this.matrix.func_70299_a(i, slot);
                    continue;
                }
                if (!remainderCurrent.func_190926_b()) {
                    if (slot.func_190926_b()) {
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.func_179545_c((ItemStack)slot, (ItemStack)remainderCurrent) && ItemStack.func_77970_a((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        remainderCurrent.func_190917_f(slot.func_190916_E());
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.func_185132_d((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (player.field_71071_by.func_70441_a(remainderCurrent)) continue;
                    player.func_71019_a(remainderCurrent, false);
                    continue;
                }
                if (slot.func_190926_b()) continue;
                this.matrix.func_70298_a(i, 1);
                slot = this.matrix.func_70301_a(i);
            }
            crafted += sizePerCraft;
            for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.matrix.func_70301_a(i);
                if (!stackInSlot.func_190926_b()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackMatcher itemStackMatcherCurrent = !recipeStack.func_190926_b() ? new ItemStackMatcher(recipeStack, false, false) : null;
                ItemStack req = tile.request(itemStackMatcherCurrent, 1, false);
                this.matrix.func_70299_a(i, req);
            }
            this.func_75130_a((IInventory)this.matrix);
        }
        this.func_75142_b();
        this.recipeLocked = false;
        this.func_75130_a((IInventory)this.matrix);
    }
}

