/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class ItemBuilder
extends Item {
    public static final String NBTBLOCKSTATE = "blockstate";
    public static final String NBT_Z = "Z";
    public static final String NBT_Y = "Y";
    public static final String NBT_X = "X";
    public static final String NBT_DIM = "dimension";
    public static final String NBT_BOUND = "bound";

    public ItemBuilder(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public static void putPos(ItemStack stack, BlockPos pos) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a(NBT_X, pos.func_177958_n());
        tag.func_74768_a(NBT_Y, pos.func_177956_o());
        tag.func_74768_a(NBT_Z, pos.func_177952_p());
    }

    public static BlockPos getPos(ItemStack stack) {
        return null;
    }

    public static String getDim(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_DIM);
    }

    public static void putDim(ItemStack stack, World world) {
        stack.func_196082_o().func_74778_a(NBT_DIM, DimPos.dimensionToString(world));
    }

    public static void setBlockState(ItemStack wand, BlockState target) {
        CompoundNBT encoded = NBTUtil.func_190009_a((BlockState)target);
        wand.func_196082_o().func_218657_a(NBTBLOCKSTATE, (INBT)encoded);
    }

    public static BlockState getBlockState(ItemStack wand) {
        if (!wand.func_196082_o().func_74764_b(NBTBLOCKSTATE)) {
            return null;
        }
        return NBTUtil.func_190008_d((CompoundNBT)wand.func_196082_o().func_74775_l(NBTBLOCKSTATE));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        BlockPos buildAt = pos.func_177972_a(context.func_196000_l());
        if (world.func_175625_s(pos) instanceof TileMain) {
            ItemStack stack = player.func_184586_b(hand);
            CompoundNBT tag = stack.func_196082_o();
            ItemBuilder.putPos(stack, pos);
            tag.func_74757_a(NBT_BOUND, true);
            ItemBuilder.putDim(stack, world);
            stack.func_77982_d(tag);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return ActionResultType.SUCCESS;
        }
        if (world.func_175623_d(buildAt) || world.func_180495_p(buildAt).func_185904_a().func_76224_d()) {
            player.func_184609_a(hand);
            ItemStack stack = player.func_184586_b(hand);
            DimPos dp = ItemBuilder.getPosStored(stack);
            if (dp != null && hand == Hand.MAIN_HAND && !world.field_72995_K) {
                ServerWorld serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.func_73046_m());
                if (serverTargetWorld == null) {
                    StorageNetwork.LOGGER.error("Missing dimension key " + dp.getDimension());
                    return ActionResultType.PASS;
                }
                TileEntity tile = serverTargetWorld.func_175625_s(dp.getBlockPos());
                BlockState targetState = ItemBuilder.getBlockState(stack);
                if (tile instanceof TileMain && targetState != null) {
                    TileMain network = (TileMain)tile;
                    BlockState bs = world.func_180495_p(pos);
                    ItemStackMatcher matcher = new ItemStackMatcher(new ItemStack((IItemProvider)targetState.func_177230_c()), false, false);
                    ItemStack found = network.request(matcher, 1, true);
                    if (!found.func_190926_b()) {
                        boolean success = this.placeStateSafe(world, player, buildAt, bs);
                        if (success) {
                            network.request(matcher, 1, false);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("item.remote.notfound.item"), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.remote.notfound"), true);
                }
            }
        }
        return ActionResultType.PASS;
    }

    private boolean placeStateSafe(World world, PlayerEntity player, BlockPos placePos, BlockState placeState) {
        BlockState stateHere = world.func_180495_p(placePos);
        if (stateHere.func_177230_c() == Blocks.field_150350_a || stateHere.func_185904_a().func_76224_d()) {
            return world.func_180501_a(placePos, placeState, 3);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t;
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_196082_o();
            int x = tag.func_74762_e(NBT_X);
            int y = tag.func_74762_e(NBT_Y);
            int z = tag.func_74762_e(NBT_Z);
            String dim = tag.func_74779_i(NBT_DIM);
            t = new TranslationTextComponent("[" + x + ", " + y + ", " + z + ", " + dim + "]");
            t.func_240699_a_(TextFormatting.DARK_GRAY);
            tooltip.add((ITextComponent)t);
        } else {
            t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
            t.func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)t);
        }
        BlockState target = ItemBuilder.getBlockState(stack);
        if (target != null) {
            String block = target.func_177230_c().func_149739_a();
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.AQUA + UtilTileEntity.lang(block)));
        } else {
            t = new TranslationTextComponent(this.func_77658_a() + ".blockstate");
            t.func_240699_a_(TextFormatting.DARK_GRAY);
            tooltip.add((ITextComponent)t);
        }
    }

    public static DimPos getPosStored(ItemStack itemStackIn) {
        if (!itemStackIn.func_196082_o().func_74767_n(NBT_BOUND)) {
            return null;
        }
        CompoundNBT tag = itemStackIn.func_196082_o();
        return new DimPos(tag);
    }

    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held.func_190926_b()) {
            return;
        }
        World world = player.func_130014_f_();
        StorageNetwork.log((Object)((Object)SsnRegistry.BUILDER_REMOTE) + " bs builder saved " + held);
        if (held.func_77973_b() == SsnRegistry.BUILDER_REMOTE) {
            BlockState target = world.func_180495_p(event.getPos());
            ItemBuilder.setBlockState(held, target);
            StorageNetwork.log("bs builder saved " + target);
            event.setResult(Event.Result.DENY);
        }
    }
}

