/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.cable.ContainerCable;
import com.lothrazar.storagenetwork.block.cable.export.ContainerCableExportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.ContainerCableImportFilter;
import com.lothrazar.storagenetwork.block.collection.ContainerCollectionFilter;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.network.RefreshFilterClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class CableIOMessage {
    private boolean isAllowlist;
    private final int id;
    private int value = 0;
    private ItemStack stack = ItemStack.field_190927_a;

    public CableIOMessage(int id) {
        this.id = id;
    }

    public CableIOMessage(int id, int value, boolean isall) {
        this(id);
        this.value = value;
        this.isAllowlist = isall;
    }

    public CableIOMessage(int id, int value, ItemStack stackin) {
        this(id);
        this.value = value;
        this.stack = stackin;
    }

    public String toString() {
        return "CableDataMessage{isAllowlist=" + this.isAllowlist + ", id=" + this.id + ", value=" + this.value + ", stack=" + this.stack + '}';
    }

    public static void handle(CableIOMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CableIOMessage.handleInternal(message, ctx));
        ctx.get().setPacketHandled(true);
    }

    private static void handleInternal(CableIOMessage message, Supplier<NetworkEvent.Context> ctx) {
        ContainerCable ctr;
        ServerPlayerEntity player = ctx.get().getSender();
        CapabilityConnectableAutoIO link = null;
        TileConnectable tile = null;
        CapabilityConnectable connectable = null;
        if (player.field_71070_bA instanceof ContainerCableExportFilter) {
            ctr = (ContainerCableExportFilter)player.field_71070_bA;
            link = ctr.cap;
            tile = ctr.tile;
        }
        if (player.field_71070_bA instanceof ContainerCableImportFilter) {
            ctr = (ContainerCableImportFilter)player.field_71070_bA;
            link = ((ContainerCableImportFilter)ctr).cap;
            tile = ((ContainerCableImportFilter)ctr).tile;
        }
        if (player.field_71070_bA instanceof ContainerCollectionFilter) {
            ctr = (ContainerCollectionFilter)player.field_71070_bA;
            connectable = ((ContainerCollectionFilter)ctr).cap;
            tile = ((ContainerCollectionFilter)ctr).tile;
        }
        TileMain root = null;
        if (link != null) {
            root = UtilTileEntity.getTileMainForConnectable(link.connectable);
        }
        CableMessageType type = CableMessageType.values()[message.id];
        switch (type) {
            case IMPORT_FILTER: {
                link.getFilter().clear();
                int targetSlot = 0;
                for (ItemStack filterSuggestion : link.getStoredStacks(false)) {
                    if (link.getFilter().exactStackAlreadyInList(filterSuggestion)) continue;
                    try {
                        link.getFilter().setStackInSlot(targetSlot, filterSuggestion.func_77946_l());
                        if (++targetSlot < link.getFilter().getSlots()) continue;
                    }
                    catch (Exception ex) {
                        StorageNetwork.LOGGER.error("Exception saving filter slot ", (Object)message);
                    }
                }
                PacketRegistry.INSTANCE.sendTo((Object)new RefreshFilterClientMessage(link.getFilter().getStacks()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                break;
            }
            case SYNC_DATA: {
                link.setPriority(link.getPriority() + message.value);
                link.getFilter().setIsAllowlist(message.isAllowlist);
                if (root == null) break;
                root.clearCache();
                break;
            }
            case SAVE_FITLER: {
                if (link != null) {
                    link.setFilter(message.value, message.stack.func_77946_l());
                    break;
                }
                if (connectable == null) break;
                connectable.setFilter(message.value, message.stack.func_77946_l());
                break;
            }
            case REDSTONE: {
                if (link != null) {
                    StorageNetwork.log("redstone link test " + link.needsRedstone());
                    link.toggleNeedsRedstone();
                }
                if (connectable == null) break;
                StorageNetwork.log("redstone toggle test " + message.value + "?" + connectable.needsRedstone());
                connectable.toggleNeedsRedstone();
            }
        }
        player.field_71135_a.func_147359_a((IPacket)tile.func_189518_D_());
    }

    public static void encode(CableIOMessage msg, PacketBuffer buffer) {
        buffer.writeInt(msg.id);
        buffer.writeInt(msg.value);
        buffer.writeBoolean(msg.isAllowlist);
        buffer.func_150786_a(msg.stack.func_77955_b(new CompoundNBT()));
    }

    public static CableIOMessage decode(PacketBuffer buffer) {
        CableIOMessage c = new CableIOMessage(buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        c.stack = ItemStack.func_199557_a((CompoundNBT)buffer.func_150793_b());
        return c;
    }

    public static enum CableMessageType {
        SYNC_DATA,
        IMPORT_FILTER,
        SAVE_FITLER,
        REDSTONE;

    }
}

