/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class ClearRecipeMessage {
    public static void handle(ClearRecipeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ClearRecipeMessage.clearContainerRecipe(player, true);
        });
        ctx.get().setPacketHandled(true);
    }

    public static ClearRecipeMessage decode(PacketBuffer buf) {
        return new ClearRecipeMessage();
    }

    public static void encode(ClearRecipeMessage msg, PacketBuffer buf) {
    }

    static void clearContainerRecipe(ServerPlayerEntity player, boolean doRefresh) {
        if (player.field_71070_bA instanceof ContainerNetwork) {
            ContainerNetwork container = (ContainerNetwork)player.field_71070_bA;
            CraftingInventory craftMatrix = container.getCraftMatrix();
            TileMain root = container.getTileMain();
            for (int i = 0; i < 9 && root != null; ++i) {
                int remainingAfter;
                int numBeforeInsert;
                ItemStack stackInSlot = craftMatrix.func_70301_a(i);
                if (stackInSlot.func_190926_b() || (numBeforeInsert = stackInSlot.func_190916_E()) == (remainingAfter = root.insertStack(stackInSlot.func_77946_l(), false))) continue;
                if (remainingAfter == 0) {
                    craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                craftMatrix.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfter));
            }
            if (doRefresh) {
                List<ItemStack> list = root.getStacks();
                PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                container.func_75142_b();
            }
        }
    }
}

