/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item.remote;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.item.remote.ItemRemote;
import com.lothrazar.storagenetwork.jei.JeiHooks;
import com.lothrazar.storagenetwork.jei.JeiSettings;
import com.lothrazar.storagenetwork.network.SortMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiNetworkRemote
extends ContainerScreen<ContainerNetworkRemote>
implements IGuiNetwork {
    private static final int HEIGHT = 256;
    private static final int WIDTH = 176;
    private static final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/inventory.png");
    private final NetworkWidget network;
    private final ItemStack remote;

    public GuiNetworkRemote(ContainerNetworkRemote screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.remote = inv.field_70458_d.func_184586_b(Hand.MAIN_HAND);
        this.network = new NetworkWidget(this);
        this.network.setLines(8);
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.network.fieldHeight = 180;
    }

    @Override
    public void renderStackTooltip(MatrixStack ms, ItemStack stack, int mousex, int mousey) {
        super.func_230457_a_(ms, stack, mousex, mousey);
    }

    @Override
    public void setStacks(List<ItemStack> stacks) {
        this.network.stacks = stacks;
    }

    @Override
    public boolean getDownwards() {
        return ItemRemote.getDownwards(this.remote);
    }

    @Override
    public void setDownwards(boolean val) {
        ItemRemote.setDownwards(this.remote, val);
    }

    @Override
    public EnumSortType getSort() {
        return ItemRemote.getSort(this.remote);
    }

    @Override
    public void setSort(EnumSortType val) {
        ItemRemote.setSort(this.remote, val);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int searchLeft = this.field_147003_i + 81;
        int searchTop = this.field_147009_r + 160;
        int width = 85;
        this.field_230712_o_.getClass();
        this.network.searchBar = new TextFieldWidget(this.field_230712_o_, searchLeft, searchTop, width, 9, null);
        this.network.searchBar.func_146203_f(30);
        this.network.initSearchbar();
        this.network.initButtons();
        this.func_230480_a_((Widget)this.network.directionBtn);
        this.func_230480_a_((Widget)this.network.sortBtn);
        if (JeiSettings.isJeiLoaded()) {
            this.func_230480_a_((Widget)this.network.jeiBtn);
        }
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
        this.network.searchBar.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.network.render();
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(texture);
        int k = (this.field_230708_k_ - this.field_146999_f) / 2;
        int l = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(ms, k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        this.network.applySearchTextToSlots();
        this.network.renderItemSlots(ms, mouseX, mouseY, this.field_230712_o_);
    }

    public void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        this.network.drawGuiContainerForegroundLayer(ms, mouseX, mouseY, this.field_230712_o_);
    }

    boolean isScrollable(double x, double y) {
        int scrollHeight = 152;
        return this.func_195359_a(0, 0, this.field_230708_k_ - 8, scrollHeight, x, y);
    }

    public boolean func_231043_a_(double x, double y, double mouseButton) {
        super.func_231043_a_(x, y, mouseButton);
        if (this.isScrollable(x, y) && mouseButton != 0.0) {
            this.network.mouseScrolled(mouseButton);
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        this.network.mouseClicked(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int b) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        if (this.network.searchBar.func_230999_j_()) {
            if (keyCode == 259) {
                this.network.syncTextToJei();
            }
            this.network.searchBar.func_231046_a_(keyCode, scanCode, b);
            return true;
        }
        if (this.network.stackUnderMouse.func_190926_b()) {
            try {
                JeiHooks.testJeiKeybind(mouseKey, this.network.stackUnderMouse);
            }
            catch (Throwable e) {
                StorageNetwork.LOGGER.error("JEI compat issue ", e);
            }
        }
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, b);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        return this.network.charTyped(typedChar, keyCode);
    }

    @Override
    public void drawGradient(MatrixStack ms, int x, int y, int x2, int y2, int u, int v) {
        super.func_238468_a_(ms, x, y, x2, y2, u, v);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public void syncDataToServer() {
        PacketRegistry.INSTANCE.sendToServer((Object)new SortMessage(null, this.getDownwards(), this.getSort()));
    }
}

