/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.ButtonRequest;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.jei.JeiHooks;
import com.lothrazar.storagenetwork.jei.JeiSettings;
import com.lothrazar.storagenetwork.network.InsertMessage;
import com.lothrazar.storagenetwork.network.RequestMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NetworkWidget {
    private final IGuiNetwork gui;
    public TextFieldWidget searchBar;
    long lastClick;
    int page = 1;
    int maxPage = 1;
    public List<ItemStack> stacks;
    List<ItemSlotNetwork> slots;
    private int lines = 4;
    private int columns = 9;
    public ItemStack stackUnderMouse = ItemStack.field_190927_a;
    public int fieldHeight = 90;
    public ButtonRequest directionBtn;
    public ButtonRequest sortBtn;
    public ButtonRequest jeiBtn;

    public NetworkWidget(IGuiNetwork gui) {
        this.gui = gui;
        this.stacks = Lists.newArrayList();
        this.slots = Lists.newArrayList();
        PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage());
        this.lastClick = System.currentTimeMillis();
    }

    public void applySearchTextToSlots() {
        ArrayList stacksToDisplay;
        String searchText = this.searchBar.func_146179_b();
        ArrayList arrayList = stacksToDisplay = searchText.equals("") ? Lists.newArrayList(this.stacks) : Lists.newArrayList();
        if (!searchText.equals("")) {
            for (ItemStack stack : this.stacks) {
                if (!this.doesStackMatchSearch(stack)) continue;
                stacksToDisplay.add(stack);
            }
        }
        this.sortStackWrappers(stacksToDisplay);
        this.applyScrollPaging(stacksToDisplay);
        this.rebuildItemSlots(stacksToDisplay);
    }

    public void clearSearch() {
        if (this.searchBar == null) {
            return;
        }
        this.searchBar.func_146180_a("");
        if (JeiSettings.isJeiSearchSynced()) {
            JeiHooks.setFilterText("");
        }
    }

    private boolean doesStackMatchSearch(ItemStack stack) {
        String searchText = this.searchBar.func_146179_b();
        if (searchText.startsWith("@")) {
            String name = UtilTileEntity.getModNameForItem(stack.func_77973_b());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("#")) {
            Minecraft mc = Minecraft.func_71410_x();
            List tooltip = stack.func_82840_a((PlayerEntity)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            List unformattedTooltip = tooltip.stream().map(ITextComponent::func_150261_e).collect(Collectors.toList());
            String tooltipString = Joiner.on((char)' ').join(unformattedTooltip).toLowerCase().trim();
            return tooltipString.contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("$")) {
            StringBuilder oreDictStringBuilder = new StringBuilder();
            for (ResourceLocation oreId : stack.func_77973_b().getTags()) {
                String oreName = oreId.toString();
                oreDictStringBuilder.append(oreName).append(' ');
            }
            return oreDictStringBuilder.toString().toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        return stack.func_200301_q().func_150261_e().toLowerCase().contains(searchText.toLowerCase());
    }

    public boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    int getLines() {
        return this.lines;
    }

    int getColumns() {
        return this.columns;
    }

    public void setLines(int v) {
        this.lines = v;
    }

    void setColumns(int v) {
        this.columns = v;
    }

    public void applyScrollPaging(List<ItemStack> stacksToDisplay) {
        this.maxPage = stacksToDisplay.size() / this.getColumns();
        if (stacksToDisplay.size() % this.getColumns() != 0) {
            ++this.maxPage;
        }
        this.maxPage -= this.getLines() - 1;
        if (this.maxPage < 1) {
            this.maxPage = 1;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
    }

    public void mouseScrolled(double mouseButton) {
        if (mouseButton > 0.0 && this.page > 1) {
            --this.page;
        }
        if (mouseButton < 0.0 && this.page < this.maxPage) {
            ++this.page;
        }
    }

    public void rebuildItemSlots(List<ItemStack> stacksToDisplay) {
        this.slots = Lists.newArrayList();
        int index = (this.page - 1) * this.getColumns();
        for (int row = 0; row < this.getLines(); ++row) {
            for (int col = 0; col < this.getColumns() && index < stacksToDisplay.size(); ++col) {
                int in = index++;
                this.slots.add(new ItemSlotNetwork(this.gui, stacksToDisplay.get(in), this.gui.getGuiLeft() + 8 + col * 18, this.gui.getGuiTop() + 10 + row * 18, stacksToDisplay.get(in).func_190916_E(), this.gui.getGuiLeft(), this.gui.getGuiTop(), true));
            }
        }
    }

    public boolean inSearchBar(double mouseX, double mouseY) {
        return this.gui.isInRegion(this.searchBar.field_230690_l_ - this.gui.getGuiLeft(), this.searchBar.field_230691_m_ - this.gui.getGuiTop(), this.searchBar.func_230998_h_(), this.searchBar.getHeight(), mouseX, mouseY);
    }

    public void initSearchbar() {
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.searchBar.func_146195_b(true);
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            this.searchBar.func_146180_a(JeiHooks.getFilterText());
        }
    }

    public void drawGuiContainerForegroundLayer(MatrixStack ms, int mouseX, int mouseY, FontRenderer font) {
        for (ItemSlotNetwork s : this.slots) {
            if (s == null || !s.isMouseOverSlot(mouseX, mouseY)) continue;
            s.drawTooltip(ms, mouseX, mouseY);
        }
        Screen screen = (Screen)this.gui;
        if (this.directionBtn != null && this.directionBtn.func_231047_b_(mouseX, mouseY)) {
            screen.renderTooltip(ms, (List)Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("gui.storagenetwork.sort")}), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop(), font);
        }
        if (this.sortBtn != null && this.sortBtn.func_231047_b_(mouseX, mouseY)) {
            screen.renderTooltip(ms, (List)Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("gui.storagenetwork.req.tooltip_" + this.gui.getSort().name().toLowerCase())}), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop(), font);
        }
        if (JeiSettings.isJeiLoaded() && this.jeiBtn != null && this.jeiBtn.func_231047_b_(mouseX, mouseY)) {
            ItemSlotNetwork s;
            s = new TranslationTextComponent(JeiSettings.isJeiSearchSynced() ? "gui.storagenetwork.fil.tooltip_jei_on" : "gui.storagenetwork.fil.tooltip_jei_off");
            screen.renderTooltip(ms, (List)Lists.newArrayList((Object[])new TranslationTextComponent[]{s}), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop(), font);
        }
        if (this.inSearchBar(mouseX, mouseY)) {
            ArrayList lis = Lists.newArrayList();
            if (!Screen.func_231173_s_()) {
                lis.add(new TranslationTextComponent(I18n.func_135052_a((String)"gui.storagenetwork.shift", (Object[])new Object[0])));
            } else {
                lis.add(new TranslationTextComponent(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_mod", (Object[])new Object[0])));
                lis.add(new TranslationTextComponent(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_tooltip", (Object[])new Object[0])));
                lis.add(new TranslationTextComponent(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_tags", (Object[])new Object[0])));
                lis.add(new TranslationTextComponent(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_clear", (Object[])new Object[0])));
            }
            screen.renderTooltip(ms, (List)lis, mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop(), font);
        }
    }

    public void renderItemSlots(MatrixStack ms, int mouseX, int mouseY, FontRenderer font) {
        this.stackUnderMouse = ItemStack.field_190927_a;
        for (ItemSlotNetwork slot : this.slots) {
            slot.drawSlot(ms, font, mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
        if (this.slots.isEmpty()) {
            this.stackUnderMouse = ItemStack.field_190927_a;
        }
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchBar.func_230999_j_() && this.searchBar.func_231042_a_(typedChar, keyCode)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.field_190927_a, false, false));
            this.syncTextToJei();
            return true;
        }
        return false;
    }

    public void syncTextToJei() {
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            JeiHooks.setFilterText(this.searchBar.func_146179_b());
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.searchBar.func_146195_b(false);
        if (this.inSearchBar(mouseX, mouseY)) {
            this.searchBar.func_146195_b(true);
            if (mouseButton == 1) {
                this.clearSearch();
                return;
            }
        }
        ItemStack stackCarriedByMouse = StorageNetwork.proxy.getClientPlayer().field_71071_by.func_70445_o();
        if (!this.stackUnderMouse.func_190926_b() && (mouseButton == 0 || mouseButton == 1) && stackCarriedByMouse.func_190926_b() && this.canClick()) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(mouseButton, this.stackUnderMouse.func_77946_l(), Screen.func_231173_s_(), Screen.func_231174_t_() || Screen.func_231172_r_()));
            this.lastClick = System.currentTimeMillis();
        } else if (!stackCarriedByMouse.func_190926_b() && this.inField((int)mouseX, (int)mouseY) && this.canClick()) {
            PacketRegistry.INSTANCE.sendToServer((Object)new InsertMessage(0, mouseButton));
            this.lastClick = System.currentTimeMillis();
        }
    }

    private boolean inField(int mouseX, int mouseY) {
        return mouseX > this.gui.getGuiLeft() + 7 && mouseX < this.gui.getGuiLeft() + 176 - 7 && mouseY > this.gui.getGuiTop() + 7 && mouseY < this.gui.getGuiTop() + this.fieldHeight;
    }

    public void initButtons() {
        int y = this.searchBar.field_230691_m_ - 4;
        this.directionBtn = new ButtonRequest(this.gui.getGuiLeft() + 6, y, "", p -> {
            this.gui.setDownwards(!this.gui.getDownwards());
            this.gui.syncDataToServer();
        });
        this.directionBtn.setHeight(16);
        this.sortBtn = new ButtonRequest(this.gui.getGuiLeft() + 22, y, "", p -> {
            this.gui.setSort(this.gui.getSort().next());
            this.gui.syncDataToServer();
        });
        this.sortBtn.setHeight(16);
        this.jeiBtn = new ButtonRequest(this.gui.getGuiLeft() + 38, y, "", p -> JeiSettings.setJeiSearchSync(!JeiSettings.isJeiSearchSynced()));
        this.jeiBtn.setHeight(16);
    }

    public void sortStackWrappers(List<ItemStack> stacksToDisplay) {
        Collections.sort(stacksToDisplay, new Comparator<ItemStack>(){
            final int mul;
            {
                this.mul = NetworkWidget.this.gui.getDownwards() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack o2, ItemStack o1) {
                switch (NetworkWidget.this.gui.getSort()) {
                    case AMOUNT: {
                        return Integer.compare(o1.func_190916_E(), o2.func_190916_E()) * this.mul;
                    }
                    case NAME: {
                        return o2.func_200301_q().toString().compareToIgnoreCase(o1.func_200301_q().toString()) * this.mul;
                    }
                    case MOD: {
                        return UtilTileEntity.getModNameForItem(o2.func_77973_b()).compareToIgnoreCase(UtilTileEntity.getModNameForItem(o1.func_77973_b())) * this.mul;
                    }
                }
                return 0;
            }
        });
    }

    public void render() {
        switch (this.gui.getSort()) {
            case AMOUNT: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_AMT);
                break;
            }
            case MOD: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_MOD);
                break;
            }
            case NAME: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_NAME);
            }
        }
        this.directionBtn.setTextureId(this.gui.getDownwards() ? ButtonRequest.TextureEnum.SORT_DOWN : ButtonRequest.TextureEnum.SORT_UP);
        this.jeiBtn.setTextureId(JeiSettings.isJeiSearchSynced() ? ButtonRequest.TextureEnum.JEI_GREEN : ButtonRequest.TextureEnum.JEI_RED);
    }
}

