/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item.remote;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemRemote
extends Item
implements INamedContainerProvider {
    public ItemRemote(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public static boolean getDownwards(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("down")) {
            return tag.func_74767_n("down");
        }
        return false;
    }

    public static void setDownwards(ItemStack stack, boolean val) {
        stack.func_196082_o().func_74757_a("down", val);
    }

    public static EnumSortType getSort(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("sort")) {
            int sort = tag.func_74762_e("sort");
            return EnumSortType.values()[sort];
        }
        return EnumSortType.NAME;
    }

    public static void setSort(ItemStack stack, EnumSortType val) {
        stack.func_196082_o().func_74768_a("sort", val.ordinal());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileMain) {
            ItemStack stack = player.func_184586_b(hand);
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74768_a("X", pos.func_177958_n());
            tag.func_74768_a("Y", pos.func_177956_o());
            tag.func_74768_a("Z", pos.func_177952_p());
            tag.func_74757_a("bound", true);
            tag.func_74778_a("dimension", DimPos.dimensionToString(world));
            stack.func_77982_d(tag);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t;
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_196082_o();
            int x = tag.func_74762_e("X");
            int y = tag.func_74762_e("Y");
            int z = tag.func_74762_e("Z");
            String dim = tag.func_74779_i("dimension");
            t = new TranslationTextComponent("[" + x + ", " + y + ", " + z + ", " + dim + "]");
        } else {
            t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        }
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    public static DimPos getPosStored(ItemStack itemStackIn) {
        if (!itemStackIn.func_196082_o().func_74767_n("bound")) {
            return null;
        }
        CompoundNBT tag = itemStackIn.func_196082_o();
        return new DimPos(tag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockPos posTarget;
        if (hand != Hand.MAIN_HAND) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack itemStackIn = player.func_184586_b(hand);
        if (!itemStackIn.func_196082_o().func_74767_n("bound")) {
            UtilTileEntity.statusMessage(player, "item.remote.notconnected");
            return super.func_77659_a(world, player, hand);
        }
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        CompoundNBT tag = itemStackIn.func_196082_o();
        int x = tag.func_74762_e("X");
        int y = tag.func_74762_e("Y");
        int z = tag.func_74762_e("Z");
        World serverTargetWorld = world;
        if (tag.func_74764_b("dimension")) {
            try {
                serverTargetWorld = DimPos.stringDimensionLookup(tag.func_74779_i("dimension"), world.func_73046_m());
                if (serverTargetWorld != null) {
                    serverTargetWorld = world;
                }
            }
            catch (Exception e) {
                StorageNetwork.LOGGER.error("why is cross dim broken ", (Throwable)e);
                return super.func_77659_a(world, player, hand);
            }
        }
        if (!serverTargetWorld.isAreaLoaded(posTarget = new BlockPos(x, y, z), 1)) {
            UtilTileEntity.chatMessage(player, "item.remote.notloaded");
            return super.func_77659_a(world, player, hand);
        }
        TileEntity tile = serverTargetWorld.func_175625_s(posTarget);
        if (tile instanceof TileMain) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ITextComponent func_145748_c_() {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a());
        return t;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        boolean crafting;
        boolean bl = crafting = this == SsnRegistry.crafting_remote;
        if (crafting) {
            return new ContainerNetworkCraftingRemote(id, inv);
        }
        return new ContainerNetworkRemote(id, inv);
    }
}

