/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class UtilTileEntity {
    private static final Map<Item, String> modNamesForIds = new HashMap<Item, String>();
    public static final int MOUSE_BTN_LEFT = 0;
    public static final int MOUSE_BTN_RIGHT = 1;
    public static final int MOUSE_BTN_MIDDLE_CLICK = 2;

    public static void chatMessage(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(message), player.func_110124_au());
        }
    }

    public static void statusMessage(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(message), true);
        }
    }

    public static String lang(String message) {
        TranslationTextComponent t = new TranslationTextComponent(message);
        return t.func_150261_e();
    }

    @Nullable
    public static TileMain getTileMainForConnectable(@Nonnull IConnectable connectable) {
        if (connectable == null || connectable.getMainPos() == null) {
            return null;
        }
        return connectable.getMainPos().getTileEntity(TileMain.class);
    }

    @Nonnull
    public static String getModNameForItem(@Nonnull Item theitem) {
        if (modNamesForIds.containsKey(theitem)) {
            return modNamesForIds.get(theitem);
        }
        String modId = theitem.getRegistryName().func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        modNamesForIds.put(theitem, lowercaseModId);
        return lowercaseModId;
    }
}

