/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import scala.actors.threadpool.Arrays;

public class AbstractRecipe {
    protected List<ItemStack> output;
    protected boolean order;
    protected List<Object> input;

    public AbstractRecipe(List<ItemStack> output, boolean order, Object ... input) {
        this.output = output;
        this.order = order;
        this.input = Lists.newArrayList((Iterable)Arrays.asList((Object[])input));
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean isOrder() {
        return this.order;
    }

    public List<Object> getInput() {
        return this.input;
    }

    public boolean match(List<ItemStack> list) {
        if (list.size() != this.input.size()) {
            return false;
        }
        if (this.order) {
            for (int i = 0; i < this.input.size(); ++i) {
                if (this.match(list.get(i), this.input.get(i))) continue;
                return false;
            }
            return true;
        }
        ArrayList foo = Lists.newArrayList(this.input);
        for (ItemStack stack : list) {
            if (stack == null) continue;
            boolean flag = false;
            for (int i = 0; i < foo.size(); ++i) {
                Object o = foo.get(i);
                if (!this.match(stack, o)) continue;
                flag = true;
                foo.remove(i);
                break;
            }
            if (flag) continue;
            return false;
        }
        return foo.isEmpty();
    }

    public boolean match(ItemStack stack, Object o) {
        if (stack == null) {
            return false;
        }
        if (o instanceof Item || o instanceof ItemStack && ((ItemStack)o).func_77952_i() == Short.MAX_VALUE) {
            return stack.func_77973_b() == o;
        }
        if (o instanceof Block) {
            return stack.func_77973_b() == Item.func_150898_a((Block)((Block)o));
        }
        if (o instanceof String) {
            return Ints.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)OreDictionary.getOreID((String)((String)o)));
        }
        if (o instanceof ItemStack) {
            return stack.func_77969_a((ItemStack)o);
        }
        return false;
    }
}

