/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.helper;

import mrriegel.storagenetwork.helper.Util;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FilterItem {
    ItemStack stack;
    boolean meta;
    boolean ore;
    boolean nbt;

    public FilterItem(ItemStack stack) {
        this(stack, stack != null ? stack.func_77952_i() != Short.MAX_VALUE : true, false, false);
    }

    public FilterItem(ItemStack stack, boolean meta, boolean ore, boolean nbt) {
        this.stack = stack;
        this.meta = meta;
        this.ore = ore;
        this.nbt = nbt;
    }

    private FilterItem() {
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound c = compound.func_74775_l("stack");
        this.stack = new ItemStack(c);
        this.meta = compound.func_74767_n("meta");
        this.ore = compound.func_74767_n("ore");
        this.nbt = compound.func_74767_n("nbt");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound c = new NBTTagCompound();
        this.stack.func_77955_b(c);
        compound.func_74782_a("stack", (NBTBase)c);
        compound.func_74757_a("meta", this.meta);
        compound.func_74757_a("ore", this.ore);
        compound.func_74757_a("nbt", this.nbt);
        return c;
    }

    public String toString() {
        return "FilterItem [stack=" + this.stack + ", meta=" + this.meta + ", ore=" + this.ore + ", nbt=" + this.nbt + "]";
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException();
        }
        this.stack = stack;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public void setMeta(boolean meta) {
        this.meta = meta;
    }

    public boolean isOre() {
        return this.ore;
    }

    public void setOre(boolean ore) {
        this.ore = ore;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public void setNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public static FilterItem loadFilterItemFromNBT(NBTTagCompound nbt) {
        FilterItem fil = new FilterItem();
        fil.readFromNBT(nbt);
        return fil.getStack() != null && fil.getStack().func_77973_b() != null ? fil : null;
    }

    public boolean match(ItemStack s) {
        if (s == null || s.func_190926_b()) {
            return false;
        }
        if (this.ore && Util.equalOreDict(s, this.stack)) {
            return true;
        }
        if (this.nbt && !ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)s)) {
            return false;
        }
        if (this.meta && s.func_77952_i() != this.stack.func_77952_i()) {
            return false;
        }
        return s.func_77973_b() == this.stack.func_77973_b();
    }
}

