/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.helper;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StackWrapper {
    ItemStack stack;
    int size;

    public StackWrapper(ItemStack stack, int size) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        this.stack = stack;
        this.size = size;
    }

    private StackWrapper() {
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound c = compound.func_74775_l("stack");
        this.stack = new ItemStack(c);
        this.size = compound.func_74762_e("size");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound c = new NBTTagCompound();
        this.stack.func_77955_b(c);
        compound.func_74782_a("stack", (NBTBase)c);
        compound.func_74768_a("size", this.size);
        return compound;
    }

    public String toString() {
        return "StackWrapper [stack=" + this.stack + ", size=" + this.size + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackWrapper)) {
            return false;
        }
        StackWrapper o = (StackWrapper)obj;
        return o.stack.func_77969_a(this.stack) && ItemStack.func_77970_a((ItemStack)o.stack, (ItemStack)this.stack);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException();
        }
        this.stack = stack;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public StackWrapper copy() {
        return new StackWrapper(this.stack.func_77946_l(), this.size);
    }

    public static StackWrapper loadStackWrapperFromNBT(NBTTagCompound nbt) {
        StackWrapper wrap = new StackWrapper();
        wrap.readFromNBT(nbt);
        return wrap.getStack() != null && wrap.getStack().func_77973_b() != null ? wrap : null;
    }
}

