/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mrriegel.storagenetwork.RigelNetworkGuiRequest;
import mrriegel.storagenetwork.helper.StackWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StacksMessage
implements IMessage,
IMessageHandler<StacksMessage, IMessage> {
    int size;
    int csize;
    List<StackWrapper> stacks;
    List<StackWrapper> craftableStacks;

    public StacksMessage() {
    }

    public StacksMessage(List<StackWrapper> stacks, List<StackWrapper> craftableStacks) {
        this.stacks = stacks;
        this.craftableStacks = craftableStacks;
        this.size = stacks.size();
        this.csize = craftableStacks.size();
    }

    public IMessage onMessage(final StacksMessage message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (Minecraft.func_71410_x().field_71462_r instanceof RigelNetworkGuiRequest) {
                    RigelNetworkGuiRequest gui = (RigelNetworkGuiRequest)Minecraft.func_71410_x().field_71462_r;
                    gui.stacks = message.stacks;
                    gui.craftableStacks = message.craftableStacks;
                }
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.size = buf.readInt();
        this.csize = buf.readInt();
        this.stacks = Lists.newArrayList();
        for (i = 0; i < this.size; ++i) {
            this.stacks.add(StackWrapper.loadStackWrapperFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
        }
        this.craftableStacks = Lists.newArrayList();
        for (i = 0; i < this.csize; ++i) {
            this.craftableStacks.add(StackWrapper.loadStackWrapperFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound compound;
        buf.writeInt(this.size);
        buf.writeInt(this.csize);
        for (StackWrapper w : this.stacks) {
            compound = new NBTTagCompound();
            w.writeToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
        }
        for (StackWrapper w : this.craftableStacks) {
            compound = new NBTTagCompound();
            w.writeToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
        }
    }
}

