/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.asm.transform;

import code.elix_x.excomms.asm.transform.children.NodeChildrenTransformer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ASMTransformer {
    private final ImmutableList<NodeChildrenTransformer<ClassNode>> transformers;

    public ASMTransformer(NodeChildrenTransformer<ClassNode> ... transformers) {
        this.transformers = ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])transformers).stream().filter(transformer -> transformer.getTargetType() == ClassNode.class).sorted((node1, node2) -> node1.getPriority() - node2.getPriority()).collect(Collectors.toList()));
    }

    public ClassNode transform(ClassNode node) {
        for (NodeChildrenTransformer transformer : this.transformers) {
            if (!transformer.accepts(node)) continue;
            node = transformer.transform(node);
        }
        return node;
    }

    public byte[] transform(byte[] bytes, int readFlags, int writeFlags) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode = this.transform(classNode);
        ClassWriter writer = new ClassWriter(writeFlags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] transform(byte[] bytes) {
        return this.transform(bytes, 0, 1);
    }
}

