/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.asm.transform.children;

import code.elix_x.excomms.asm.transform.NodeTransformer;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class NodeChildrenTransformer<T>
implements NodeTransformer<T> {
    private final ImmutableList<Pair<Function<T, Pair<Class, Collection<?>>>, NodeTransformer>> nodes;
    private final Function<Triple<T, ?, ?>, T> modified;

    public NodeChildrenTransformer(Multimap<Function<T, Pair<Class, Collection<?>>>, NodeTransformer> nodes, Function<Triple<T, ?, ?>, T> modified) {
        TreeSet dispatched = new TreeSet((pair1, pair2) -> ((NodeTransformer)pair1.getRight()).getPriority() - ((NodeTransformer)pair2.getRight()).getPriority());
        dispatched.addAll(Collections2.transform((Collection)nodes.entries(), entry -> new ImmutablePair(entry.getKey(), entry.getValue())));
        this.nodes = ImmutableList.copyOf(dispatched);
        this.modified = modified;
    }

    @Override
    public T transform(T parent) {
        for (Pair pair : this.nodes) {
            NodeTransformer node = (NodeTransformer)pair.getRight();
            if (pair.getLeft() != null) {
                Pair res = (Pair)((Function)pair.getLeft()).apply(parent);
                for (Object target : (Collection)res.getRight()) {
                    if (!node.getTargetType().isAssignableFrom((Class)res.getLeft()) || !node.accepts(target)) continue;
                    parent = this.modified.apply((Triple<ImmutableTriple, ?, ?>)new ImmutableTriple(parent, target, node.transform(target)));
                }
                continue;
            }
            if (!node.getTargetType().isAssignableFrom(parent.getClass()) || !node.accepts(parent)) continue;
            parent = this.modified.apply((Triple<ImmutableTriple, ?, ?>)new ImmutableTriple(parent, parent, node.transform(parent)));
        }
        return parent;
    }

    public static class Builder<T> {
        private Multimap<Function<T, Pair<Class, Collection<?>>>, NodeTransformer> nodes = HashMultimap.create();
        private Map<Class, Function<Triple<T, ?, ?>, T>> modified = new HashMap();

        public Builder node(Function<T, Pair<Class, Collection<?>>> parent2children, NodeTransformer transformer, Function<Triple<T, ?, ?>, T> modified) {
            this.nodes.put(parent2children, (Object)transformer);
            this.modified.put(transformer.getTargetType(), modified);
            return this;
        }

        protected Builder nodeG(Function parent2children, NodeTransformer transformer, Function modified) {
            return this.node(parent2children, transformer, modified);
        }

        protected Multimap<Function<T, Pair<Class, Collection<?>>>, NodeTransformer> nodes() {
            return this.nodes;
        }

        protected Function<Triple<T, ?, ?>, T> modified() {
            return this.modified.entrySet().stream().collect(Collectors.reducing(triple -> triple.getLeft(), entry -> triple -> triple.getMiddle() != null && ((Class)entry.getKey()).isAssignableFrom(triple.getMiddle().getClass()) || triple.getRight() != null && ((Class)entry.getKey()).isAssignableFrom(triple.getRight().getClass()) ? ((Function)entry.getValue()).apply(triple) : triple.getLeft(), (f1, f2) -> triple -> f2.apply(new ImmutableTriple(f1.apply(triple), triple.getMiddle(), triple.getRight()))));
        }
    }
}

