/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.asm.transform.specific;

import code.elix_x.excomms.asm.transform.OpcodeGroups;
import code.elix_x.excomms.asm.transform.specific.SpecificNodeTransformer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class SpecificMethodNodeTransformer
extends SpecificNodeTransformer<MethodNode> {
    private final String target;

    public SpecificMethodNodeTransformer(String target, int priority, Function<MethodNode, MethodNode> transform) {
        super(MethodNode.class, priority, transform);
        this.target = target;
    }

    public SpecificMethodNodeTransformer(int priority, String target, Consumer<MethodNode> transform) {
        super(priority, MethodNode.class, transform);
        this.target = target;
    }

    public static SpecificMethodNodeTransformer instructionsTransformer(String target, int priority, Function<InsnList, InsnList> insnOld2new) {
        return new SpecificMethodNodeTransformer(priority, target, node -> {
            node.instructions = (InsnList)insnOld2new.apply(node.instructions);
        });
    }

    public static SpecificMethodNodeTransformer instructionsTransformer(int priority, String target, Consumer<InsnList> insnConsumer) {
        return new SpecificMethodNodeTransformer(priority, target, node -> insnConsumer.accept(node.instructions));
    }

    public static SpecificMethodNodeTransformer instructionsBeginningInserter(String target, int priority, InsnList insn) {
        return SpecificMethodNodeTransformer.instructionsTransformer(priority, target, (InsnList instructions) -> instructions.insert(insn));
    }

    public static SpecificMethodNodeTransformer instructionsInserter(String target, int priority, Function<InsnList, AbstractInsnNode> where, InsnList insn, boolean before) {
        return SpecificMethodNodeTransformer.instructionsTransformer(priority, target, (InsnList instructions) -> {
            if (before) {
                instructions.insertBefore((AbstractInsnNode)where.apply((InsnList)instructions), insn);
            } else {
                instructions.insert((AbstractInsnNode)where.apply((InsnList)instructions), insn);
            }
        });
    }

    public static SpecificMethodNodeTransformer instructionsInserter(String target, int priority, Function<AbstractInsnNode, Pair<InsnList, Boolean>> inserter) {
        return SpecificMethodNodeTransformer.instructionsTransformer(priority, target, (InsnList instructions) -> {
            for (AbstractInsnNode node : instructions.toArray()) {
                Pair pair = (Pair)inserter.apply(node);
                if (pair == null) continue;
                if (((Boolean)pair.getRight()).booleanValue()) {
                    instructions.insertBefore(node, (InsnList)pair.getLeft());
                    continue;
                }
                instructions.insert(node, (InsnList)pair.getLeft());
            }
        });
    }

    public static SpecificMethodNodeTransformer instructionsInserterBeforeReturn(String target, int priority, Supplier<InsnList> insn) {
        return SpecificMethodNodeTransformer.instructionsInserter(target, priority, node -> OpcodeGroups.RETURN.contains((Object)node.getOpcode()) ? new ImmutablePair(insn.get(), (Object)true) : null);
    }

    public static SpecificMethodNodeTransformer instructionsNodesTransformer(String target, int priority, Function<AbstractInsnNode, AbstractInsnNode> insnOld2new) {
        return SpecificMethodNodeTransformer.instructionsTransformer(priority, target, (InsnList instructions) -> {
            for (AbstractInsnNode node : instructions.toArray()) {
                AbstractInsnNode res = (AbstractInsnNode)insnOld2new.apply(node);
                if (res != null) {
                    instructions.set(node, res);
                    continue;
                }
                instructions.remove(node);
            }
        });
    }

    @Override
    public boolean accepts(MethodNode target) {
        return target != null && (this.target.contains("(") ? this.target.equals(target.name + target.desc) : this.target.equals(target.name));
    }
}

