/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.asm.transform.specific;

import code.elix_x.excomms.asm.transform.NodeTransformer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class SpecificNodeTransformer<T>
implements NodeTransformer<T> {
    private final Class<T> target;
    private final int priority;
    private final Function<T, T> transform;

    public SpecificNodeTransformer(Class<T> target, int priority, Function<T, T> transform) {
        this.target = target;
        this.priority = priority;
        this.transform = transform;
    }

    public SpecificNodeTransformer(int priority, Class<T> target, Consumer<T> transform) {
        this(target, priority, (T old) -> {
            transform.accept(old);
            return old;
        });
    }

    @Override
    public Class<T> getTargetType() {
        return this.target;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public T transform(T original) {
        return this.transform.apply(original);
    }
}

