/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.jstructure;

import java.util.function.Function;

public class JavaStructure {

    public final class JParameter<T> {
        private final JModifiers modifiers;
        private final JType<T> type;

        public JParameter(JModifiers modifiers, JType<T> type) {
            this.modifiers = modifiers.mask(JModifiersMask.PARAMETER);
            this.type = type;
        }

        public JModifiers modifiers() {
            return this.modifiers;
        }

        public JType<T> type() {
            return this.type;
        }
    }

    public static class JClass<T>
    implements JType<T> {
        public static final JClass<Object> OBJECT = new JClass(new JModifiers(Object.class.getModifiers()), Object.class.getName(), null, new JInterface[0], clas -> new JField[0], clas -> {
            JConstructor[] jConstructorArray = new JConstructor[1];
            JClass jClass = clas;
            jClass.getClass();
            jConstructorArray[0] = jClass.new JConstructor(new JModifiers(JModifier.PUBLIC.mask()));
            return jConstructorArray;
        }, clas -> new JMethod[0]);
        private final JModifiers modifiers;
        private final String name;
        private final JClass<? super T> superClass;
        private final JInterface[] interfaces;
        private final JField[] fields;
        private final JConstructor[] constructors;
        private final JMethod[] methods;

        public JClass(JModifiers modifiers, String name, JClass<? super T> superClass, JInterface[] interfaces, Function<JClass<T>, JField[]> fields, Function<JClass<T>, JConstructor[]> constructors, Function<JClass<T>, JMethod[]> methods) {
            this.modifiers = modifiers.mask(JModifiersMask.CLASS);
            this.name = name;
            this.superClass = superClass;
            this.interfaces = interfaces;
            this.fields = fields.apply(this);
            this.constructors = constructors.apply(this);
            this.methods = methods.apply(this);
        }

        public static final <T> JClass<T> fromClass(Class<T> clas) {
            return null;
        }

        public final JModifiers modifiers() {
            return this.modifiers;
        }

        public final String name() {
            return this.name;
        }

        public final JClass<? super T> superClass() {
            return this.superClass;
        }

        public JInterface[] interfaces() {
            return this.interfaces;
        }

        public final JField[] fields() {
            return this.fields;
        }

        public final JConstructor[] cConstructors() {
            return this.constructors;
        }

        public final JMethod[] methods() {
            return this.methods;
        }

        public final class JMethod<R> {
            private final JModifiers modifiers;
            private final JType<R> type;
            private final String name;
            private final JParameter[] parameters;

            public JMethod(JModifiers modifiers, JType<R> type, String name, JParameter ... parameters) {
                this.modifiers = modifiers.mask(JModifiersMask.METHOD);
                this.type = type;
                this.name = name;
                this.parameters = parameters;
            }

            public JClass<T> clas() {
                return JClass.this;
            }

            public JModifiers modifiers() {
                return this.modifiers;
            }

            public JType<R> returnType() {
                return this.type;
            }

            public String name() {
                return this.name;
            }

            public JParameter[] parameters() {
                return this.parameters;
            }
        }

        public final class JConstructor {
            private final JModifiers modifiers;

            public JConstructor(JModifiers modifiers) {
                this.modifiers = modifiers.mask(JModifiersMask.CONSTRUCTOR);
            }

            public JModifiers modifiers() {
                return this.modifiers;
            }

            public JClass<T> clas() {
                return JClass.this;
            }
        }

        public final class JField<F> {
            private final JModifiers modifiers;
            private final JType<F> type;
            private final String name;

            public JField(JModifiers modifiers, JType<F> type, String name) {
                this.modifiers = modifiers.mask(JModifiersMask.FIELD);
                this.type = type;
                this.name = name;
            }

            public JClass<T> clas() {
                return JClass.this;
            }

            public JModifiers modifiers() {
                return this.modifiers;
            }

            public JType<F> type() {
                return this.type;
            }

            public String name() {
                return this.name;
            }
        }

        public static final class JInterface<T>
        extends JClass<T> {
            public JInterface(JModifiers modifiers, String name, JInterface[] interfaces, Function<JClass<T>, JMethod[]> methods) {
                super(modifiers.with(JModifier.ABSTRACT, true).with(JModifier.INTERFACE, true).mask(JModifiersMask.INTERFACE), name, null, interfaces, clas -> new JField[0], clas -> new JConstructor[0], methods);
            }
        }
    }

    public static final class JModifiers {
        private final int mask;

        public JModifiers(int mask) {
            this.mask = mask;
        }

        public boolean is(JModifier modifier) {
            return (this.mask & modifier.mask) != 0;
        }

        public JModifiers with(JModifier modifier, boolean active) {
            return new JModifiers(active ? this.mask | modifier.mask : this.mask & ~modifier.mask);
        }

        public JModifiers mask(JModifiersMask mask) {
            return new JModifiers(this.mask & mask.mask);
        }
    }

    public static interface JType<T> {
    }

    public static enum JPrimitive implements JType
    {
        BOOLEAN(JClass.fromClass(Boolean.TYPE), JClass.fromClass(Boolean.class), 1),
        BYTE(JClass.fromClass(Byte.TYPE), JClass.fromClass(Byte.class), 8),
        SHORT(JClass.fromClass(Short.TYPE), JClass.fromClass(Short.class), 16),
        INT(JClass.fromClass(Integer.TYPE), JClass.fromClass(Integer.class), 32),
        LONG(JClass.fromClass(Long.TYPE), JClass.fromClass(Long.class), 64),
        FLOAT(JClass.fromClass(Float.TYPE), JClass.fromClass(Float.class), 32),
        DOUBLE(JClass.fromClass(Double.TYPE), JClass.fromClass(Double.class), 64),
        CHAR(JClass.fromClass(Character.TYPE), JClass.fromClass(Character.class), 16);

        private final JClass primitive;
        private final JClass boxed;
        private final int bits;

        private JPrimitive(JClass primitive, JClass boxed, int bits) {
            this.primitive = primitive;
            this.boxed = boxed;
            this.bits = bits;
        }

        public <T> JClass<T> primitive() {
            return this.primitive;
        }

        public <T> JClass<T> boxed() {
            return this.boxed;
        }

        public int bits() {
            return this.bits;
        }

        public int bytes() {
            return (int)Math.ceil((float)this.bits / 8.0f);
        }
    }

    public static enum JModifiersMask {
        CLASS(3103),
        INTERFACE(3087),
        CONSTRUCTOR(7),
        METHOD(3391),
        FIELD(223),
        PARAMETER(16),
        ACCESS(7);

        private final int mask;

        private JModifiersMask(int mask) {
            this.mask = mask;
        }
    }

    public static enum JModifier {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        STATIC,
        FINAL,
        SYNCHRONIZED,
        VOLATILE,
        TRANSIENT,
        NATIVE,
        INTERFACE,
        ABSTRACT,
        STRICT,
        BRIDGE,
        VARARGS,
        SYNTHETIC,
        ANNOTATION,
        ENUM,
        MANDATED;

        private final int bit = this.ordinal();
        private final int mask = (int)Math.pow(2.0, this.bit);

        public int bit() {
            return this.bit;
        }

        public int mask() {
            return this.mask;
        }
    }
}

