/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.reflection;

import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class ReflectionHelper {
    private static final Field fieldConstructorModifiers;
    private static final Field fieldFieldModifiers;
    private static final Field fieldMethodModifiers;

    public static Field findField(Class<?> claz, String ... names) {
        Exception e = null;
        Class<?> clas = claz;
        while (claz != null) {
            for (String name : names) {
                try {
                    return clas.getDeclaredField(name);
                }
                catch (Exception ee) {
                    e = ee;
                }
            }
            clas = claz.getSuperclass();
        }
        throw new IllegalArgumentException(e);
    }

    public static Method findMethod(Class<?> claz, String[] names, Class<?> ... args) {
        Exception e = null;
        Class<?> clas = claz;
        while (claz != null) {
            for (String name : names) {
                try {
                    return clas.getDeclaredMethod(name, args);
                }
                catch (Exception ee) {
                    e = ee;
                }
            }
            clas = claz.getSuperclass();
        }
        throw new IllegalArgumentException(e);
    }

    static {
        try {
            fieldConstructorModifiers = Constructor.class.getDeclaredField("modifiers");
            fieldConstructorModifiers.setAccessible(true);
            fieldFieldModifiers = Field.class.getDeclaredField("modifiers");
            fieldFieldModifiers.setAccessible(true);
            fieldMethodModifiers = Method.class.getDeclaredField("modifiers");
            fieldMethodModifiers.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class AMethod<C, T>
    extends AccessibleReflectionObject<C, Method, AMethod<C, T>> {
        private AMethod(AClass<C> clas, Method method) {
            super(clas, method, null);
        }

        @Override
        public boolean is(Modifier modifier) {
            return modifier.is(((Method)this.get()).getModifiers());
        }

        @Override
        public AMethod<C, T> set(Modifier modifier, boolean on) {
            try {
                fieldMethodModifiers.setInt(this.get(), modifier.set(((Method)this.get()).getModifiers(), on));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public <I extends C> T invoke(I instance, Object ... args) {
            try {
                return (T)((Method)this.get()).invoke(instance, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AField<C, T>
    extends AccessibleReflectionObject<C, Field, AField<C, T>> {
        private AField(AClass<C> clas, Field field) {
            super(clas, field, null);
        }

        @Override
        public boolean is(Modifier modifier) {
            return modifier.is(((Field)this.get()).getModifiers());
        }

        @Override
        public AField<C, T> set(Modifier modifier, boolean on) {
            try {
                fieldFieldModifiers.setInt(this.get(), modifier.set(((Field)this.get()).getModifiers(), on));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public AField<C, T> setFinal(boolean finall) {
            return this.set(Modifier.FINAL, finall);
        }

        public <I extends C> T get(I instance) {
            try {
                return (T)((Field)this.get()).get(instance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <I extends C> void set(I instance, Object t) {
            try {
                ((Field)this.get()).set(instance, t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AConstructor<C>
    extends AccessibleReflectionObject<C, Constructor<C>, AConstructor<C>> {
        private AConstructor(AClass<C> clas, Constructor<C> constructor) {
            super(clas, constructor, null);
        }

        @Override
        public boolean is(Modifier modifier) {
            return modifier.is(((Constructor)this.get()).getModifiers());
        }

        @Override
        public AConstructor<C> set(Modifier modifier, boolean on) {
            try {
                fieldConstructorModifiers.setInt(this.get(), modifier.set(((Constructor)this.get()).getModifiers(), on));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public C newInstance(Object ... args) {
            try {
                return (C)((Constructor)this.get()).newInstance(args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class AccessibleReflectionObject<C, T extends AccessibleObject, R extends AccessibleReflectionObject<C, T, R>>
    extends ReflectionObject<C, T, R>
    implements IAccessibleReflectionObject<C, T, R> {
        private AccessibleReflectionObject(AClass<C> clas, T t) {
            super(clas, t);
        }

        @Override
        public boolean isAccessible() {
            return ((AccessibleObject)this.get()).isAccessible();
        }

        @Override
        public R setAccessible(boolean accessible) {
            ((AccessibleObject)this.get()).setAccessible(accessible);
            return (R)this;
        }

        /* synthetic */ AccessibleReflectionObject(AClass x0, AccessibleObject x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class ReflectionObject<C, T, R extends ReflectionObject<C, T, R>> {
        private final AClass<C> clas;
        private final T t;

        private ReflectionObject(AClass<C> clas, T t) {
            this.clas = clas;
            this.t = t;
        }

        public AClass<C> clas() {
            return this.clas;
        }

        public final T get() {
            return this.t;
        }

        public List<Modifier> modifiers() {
            return Lists.newArrayList((Object[])Modifier.values()).stream().filter(modifier -> this.is((Modifier)((Object)modifier))).collect(Collectors.toList());
        }

        public abstract boolean is(Modifier var1);

        public abstract R set(Modifier var1, boolean var2);
    }

    public static class AClass<C> {
        protected final Class<C> clas;

        public AClass(Class<C> clas) {
            this.clas = clas;
        }

        public AClass(String clas) {
            try {
                this.clas = Class.forName(clas);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Class<C> get() {
            return this.clas;
        }

        public Optional<AClass<? super C>> getSuperclass() {
            return this.clas.getSuperclass() != null ? Optional.of(new AClass<C>(this.clas.getSuperclass())) : Optional.empty();
        }

        public boolean isInterface() {
            return this.clas.isInterface();
        }

        public AInterface<C> asInterface() {
            return new AInterface(this.clas);
        }

        public boolean isEnum() {
            return this.clas.isEnum();
        }

        public <E extends Enum<E>> AEnum<E> asEnum() {
            return new AEnum(this.clas);
        }

        public boolean isAnnotation() {
            return this.clas.isAnnotation();
        }

        public AAnnotation<C> asAnnotation() {
            return new AAnnotation(this.clas);
        }

        public AConstructor<C> getDeclaredConstructor(Class<?> ... args) {
            try {
                return new AConstructor(this, this.clas.getDeclaredConstructor(args));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        public List<AConstructor<C>> getDeclaredConstructors() {
            return Lists.transform(Arrays.asList(this.clas.getDeclaredConstructors()), constructor -> new AConstructor(this, (Constructor)constructor));
        }

        public <T> AField<C, T> getDeclaredField(String ... names) {
            return new AField(this, ReflectionHelper.findField(this.clas, names));
        }

        public List<AField<C, ?>> getDeclaredFields() {
            return Lists.transform(Arrays.asList(this.clas.getDeclaredFields()), field -> new AField(this, (Field)field));
        }

        public List<AField<? super C, ?>> getFields() {
            ArrayList sup = new ArrayList();
            this.getSuperclass().ifPresent(clas -> sup.addAll(clas.getFields()));
            sup.addAll(this.getDeclaredFields());
            return sup;
        }

        public <T> AMethod<C, T> getDeclaredMethod(String[] names, Class<?> ... args) {
            return new AMethod(this, ReflectionHelper.findMethod(this.clas, names, args));
        }

        public List<AMethod<C, ?>> getDeclaredMethods() {
            return Lists.transform(Arrays.asList(this.clas.getDeclaredMethods()), method -> new AMethod(this, (Method)method));
        }

        public List<AMethod<? super C, ?>> getMethods() {
            ArrayList sup = new ArrayList();
            this.getSuperclass().ifPresent(clas -> sup.addAll(clas.getMethods()));
            sup.addAll(this.getDeclaredMethods());
            return sup;
        }

        public static class AAnnotation<C>
        extends AClass<C> {
            private AAnnotation(Class<C> clas) {
                super(clas);
            }
        }

        public static class AEnum<C extends Enum<C>>
        extends AClass<C> {
            private static final AClass<?> reflectionFactory = new AClass("sun.reflect.ReflectionFactory");
            private static final AMethod getReflectionFactory = (AMethod)reflectionFactory.getDeclaredMethod(new String[]{"getReflectionFactory"}, new Class[0]).setAccessible(true);
            private static final AMethod newConstructorAccessor = (AMethod)reflectionFactory.getDeclaredMethod(new String[]{"newConstructorAccessor"}, Constructor.class).setAccessible(true);
            private static final AClass<?> constructorAccessor = new AClass("sun.reflect.ConstructorAccessor");
            private static final AMethod newInstance = (AMethod)constructorAccessor.getDeclaredMethod(new String[]{"newInstance"}, Object[].class).setAccessible(true);
            private final AField<C, C[]> VALUES = this.getDeclaredField("$VALUES", "ENUM$VALUES");
            private final Object factory;

            private AEnum(Class<C> clas) {
                super(clas);
                ((AField)this.VALUES.setAccessible(true)).setFinal(false);
                this.factory = getReflectionFactory.invoke(null, new Object[0]);
            }

            public C[] enums() {
                return (Enum[])this.clas.getEnumConstants();
            }

            public C getEnum(int ordinal) {
                return (C)this.enums()[ordinal];
            }

            public C getEnum(String name) {
                return (C)Enum.valueOf(this.clas, name);
            }

            public C createEnum(String name, Object ... params) {
                params = ArrayUtils.addAll((Object[])new Object[]{name, this.enums().length}, (Object[])params);
                Class[] paramc = Arrays.stream(params).map(param -> param.getClass()).collect(Collectors.toList()).toArray(new Class[0]);
                paramc[1] = Integer.TYPE;
                return (C)((Enum)newInstance.invoke(newConstructorAccessor.invoke(this.factory, this.getDeclaredConstructor(paramc).get()), new Object[]{params}));
            }

            public C addEnum(String name, Object ... params) {
                C c = this.createEnum(name, params);
                this.VALUES.set(null, ArrayUtils.add((Object[])this.clas.getEnumConstants(), c));
                return c;
            }

            public void removeEnum(C c) {
                this.VALUES.set(null, ArrayUtils.removeElement((Object[])this.enums(), c));
            }
        }

        public static class AInterface<C>
        extends AClass<C> {
            private AInterface(Class<C> clas) {
                super(clas);
            }

            public C proxy(InvocationHandler handler, AInterface<?> ... interfaces) {
                return this.proxy(this.clas.getClassLoader(), handler, interfaces);
            }

            public C proxy(ClassLoader loader, InvocationHandler handler, AInterface<?> ... interfaces) {
                return (C)Proxy.newProxyInstance(loader, Arrays.stream(ArrayUtils.add((Object[])interfaces, (int)0, (Object)this)).map(iface -> iface.clas).collect(Collectors.toList()).toArray(new Class[0]), handler);
            }
        }
    }

    private static interface IAccessibleReflectionObject<C, T, R extends ReflectionObject<C, T, R>> {
        public boolean isAccessible();

        public R setAccessible(boolean var1);
    }

    public static enum Modifier {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        STATIC,
        FINAL,
        SYNCHRONIZED,
        VOLATILE,
        TRANSIENT,
        NATIVE,
        INTERFACE,
        ABSTRACT,
        STRICT,
        BRIDGE,
        VARARGS,
        SYNTHETIC,
        ANNOTATION,
        ENUM,
        MANDATED;

        final int modifier = (Integer)((AField)new AClass<java.lang.reflect.Modifier>(java.lang.reflect.Modifier.class).getDeclaredField(this.name()).setAccessible(true)).get(null);

        private boolean is(int original) {
            return (original & this.modifier) != 0;
        }

        private int set(int original, boolean on) {
            if (on) {
                return original | this.modifier;
            }
            return original & ~this.modifier;
        }
    }
}

