/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.fixes.SoundFixWrapper;
import valkyrienwarfare.interaction.EntityDraggable;
import valkyrienwarfare.interaction.IDraggable;
import valkyrienwarfare.network.PlayerShipRefrenceMessage;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.WorldPhysObjectManager;

public class EventsClient {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static double oldXOff;
    private static double oldYOff;
    private static double oldZOff;

    protected static final Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static void updatePlayerMouseOver(Entity entity) {
        if (entity != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        Minecraft.func_71410_x().field_71460_t.func_78473_a(Minecraft.func_71410_x().func_184121_ak());
    }

    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent event) {
        ISound sound = event.getSound();
        BlockPos pos = new BlockPos((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i());
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)Minecraft.func_71410_x().field_71441_e, pos);
        if (wrapper != null) {
            Vector newSoundLocation = new Vector(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, newSoundLocation);
            SoundFixWrapper soundFix = new SoundFixWrapper(sound, wrapper, newSoundLocation);
            event.setResultSound((ISound)soundFix);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (EventsClient.mc.field_71441_e != null) {
            EntityPlayerSP o;
            IDraggable draggable;
            if (!mc.func_147113_T()) {
                WorldPhysObjectManager manager = ValkyrienWarfareMod.physicsManager.getManagerForWorld((World)EventsClient.mc.field_71441_e);
                if (event.phase == TickEvent.Phase.END) {
                    for (PhysicsWrapperEntity wrapper : manager.physicsEntities) {
                        wrapper.wrapping.onPostTickClient();
                    }
                    EntityDraggable.tickAddedVelocityForWorld((World)EventsClient.mc.field_71441_e);
                }
            }
            if (event.phase == TickEvent.Phase.END && (draggable = (IDraggable)(o = Minecraft.func_71410_x().field_71439_g)).getWorldBelowFeet() != null) {
                PlayerShipRefrenceMessage playerPosMessage = new PlayerShipRefrenceMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, draggable.getWorldBelowFeet());
                ValkyrienWarfareMod.physWrapperNetwork.sendToServer((IMessage)playerPosMessage);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
    }

    @SubscribeEvent
    public void onChunkLoadClient(ChunkEvent.Load event) {
    }

    @SubscribeEvent
    public void onChunkUnloadClient(ChunkEvent.Unload event) {
    }

    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (EventsClient.mc.field_71439_g == null || EventsClient.mc.field_71442_b != null) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDrawBlockHighlightEventFirst(DrawBlockHighlightEvent event) {
        RayTraceResult objectOver;
        PhysicsWrapperEntity wrapper;
        GL11.glPushMatrix();
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        if (pos != null && (wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)Minecraft.func_71410_x().field_71441_e, pos)) != null && wrapper.wrapping != null && wrapper.wrapping.renderer != null && wrapper.wrapping.centerCoord != null && (objectOver = Minecraft.func_71410_x().field_71476_x) != null && objectOver.field_72307_f != null) {
            VertexBuffer buffer = Tessellator.func_178181_a().func_178180_c();
            oldXOff = buffer.field_179004_l;
            oldYOff = buffer.field_179005_m;
            oldZOff = buffer.field_179002_n;
            buffer.func_178969_c((double)(-wrapper.wrapping.renderer.offsetPos.func_177958_n()), (double)(-wrapper.wrapping.renderer.offsetPos.func_177956_o()), (double)(-wrapper.wrapping.renderer.offsetPos.func_177952_p()));
            wrapper.wrapping.renderer.setupTranslation(event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onDrawBlockHighlightEventLast(DrawBlockHighlightEvent event) {
        RayTraceResult objectOver;
        PhysicsWrapperEntity wrapper;
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        if (pos != null && (wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)Minecraft.func_71410_x().field_71441_e, pos)) != null && wrapper.wrapping != null && wrapper.wrapping.renderer != null && wrapper.wrapping.centerCoord != null && (objectOver = Minecraft.func_71410_x().field_71476_x) != null && objectOver.field_72307_f != null) {
            VertexBuffer buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.field_179004_l = oldXOff;
            buffer.field_179005_m = oldYOff;
            buffer.field_179002_n = oldZOff;
        }
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void interaction(PlayerInteractEvent.LeftClickBlock event) {
    }
}

