/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.combat.entity.EntityMountingWeaponBase;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.capability.IAirshipCounterCapability;
import valkyrienwarfare.interaction.ValkyrienWarfareWorldEventListener;
import valkyrienwarfare.mixin.MixinLoaderForge;
import valkyrienwarfare.physicsmanagement.PhysicsTickHandler;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.ShipType;

public class EventsCommon {
    public static HashMap<EntityPlayerMP, Double[]> lastPositions = new HashMap();

    private static final Field[] getFields(Explosion toSet) {
        try {
            Field positionField;
            Field zField;
            Field yField;
            Field xField;
            if (!MixinLoaderForge.isObfuscatedEnvironment) {
                xField = toSet.getClass().getDeclaredField("explosionX");
                xField.setAccessible(true);
                yField = toSet.getClass().getDeclaredField("explosionY");
                yField.setAccessible(true);
                zField = toSet.getClass().getDeclaredField("explosionZ");
                zField.setAccessible(true);
                positionField = toSet.getClass().getDeclaredField("position");
                positionField.setAccessible(true);
            } else {
                xField = toSet.getClass().getDeclaredField("field_77284_b");
                xField.setAccessible(true);
                yField = toSet.getClass().getDeclaredField("field_77285_c");
                yField.setAccessible(true);
                zField = toSet.getClass().getDeclaredField("field_77282_d");
                zField.setAccessible(true);
                positionField = toSet.getClass().getDeclaredField("position");
                positionField.setAccessible(true);
            }
            return new Field[]{xField, yField, zField, positionField};
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final boolean setExplosionPosition(Explosion toSet, double x, double y, double z, Field[] fields) {
        if (fields == null) {
            return false;
        }
        try {
            Field xField = fields[0];
            Field yField = fields[1];
            Field zField = fields[2];
            Field positionField = fields[3];
            double testX = toSet.field_77284_b;
            xField.setDouble(toSet, x);
            double testY = toSet.field_77285_c;
            yField.setDouble(toSet, y);
            double testZ = toSet.field_77282_d;
            zField.setDouble(toSet, z);
            positionField.set(toSet, new Vec3d(x, y, z));
            toSet.func_180343_e().clear();
            toSet.func_77277_b().clear();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(player.field_70170_p, pos);
        if (wrapper != null && player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            player.func_145747_a((ITextComponent)new TextComponentString("Spawn Point Set!"));
            player.func_180473_a(pos, true);
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        if (!event.getWorld().field_72995_K && (stack = event.getItemStack()) != null && stack.func_77973_b() instanceof ItemNameTag) {
            BlockPos posAt = event.getPos();
            EntityPlayer player = event.getEntityPlayer();
            World world = event.getWorld();
            PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(world, posAt);
            if (wrapper != null) {
                wrapper.func_96094_a(stack.func_82833_r());
                --stack.field_77994_a;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        BlockPos posAt = new BlockPos(entity);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(world, posAt);
        if (!(entity instanceof EntityFallingBlock) && wrapper != null && wrapper.wrapping.coordTransform != null) {
            if (entity instanceof EntityMountingWeaponBase || entity instanceof EntityArmorStand || entity instanceof EntityPig || entity instanceof EntityBoat) {
                wrapper.wrapping.fixEntity(entity, new Vector(entity));
                wrapper.wrapping.queueEntityForMounting(entity);
            }
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, wrapper.wrapping.coordTransform.lToWRotation, entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTickEvent(TickEvent event) {
        if (event instanceof TickEvent.WorldTickEvent) {
            World worldFor = ((TickEvent.WorldTickEvent)event).world;
            if (!worldFor.field_72995_K) {
                if (event.phase == TickEvent.Phase.START) {
                    PhysicsTickHandler.onWorldTickStart(worldFor);
                }
                if (event.phase == TickEvent.Phase.END) {
                    PhysicsTickHandler.onWorldTickEnd(worldFor);
                    if (worldFor instanceof WorldServer) {
                        // empty if block
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void worldTick(TickEvent.WorldTickEvent event) {
        World worldFor;
        if (event.phase != TickEvent.Phase.END || event.world.field_72995_K || (worldFor = event.world) instanceof WorldServer) {
            // empty if block
        }
    }

    public void addOrRemovedAllShipChunksFromMap(WorldServer worldFor, boolean amAdding) {
        for (PhysicsWrapperEntity wrapper : ValkyrienWarfareMod.physicsManager.getManagerForWorld((World)worldFor).physicsEntities) {
            Chunk[][] chunkArray = wrapper.wrapping.claimedChunks;
            int n = chunkArray.length;
            for (int i = 0; i < n; ++i) {
                Chunk[] chunks;
                for (Chunk chunk : chunks = chunkArray[i]) {
                    if (!amAdding) continue;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFillBucketEvent(FillBucketEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player != null) {
            EntityPlayerMP p = (EntityPlayerMP)event.player;
            Double[] pos = lastPositions.get(p);
            if (pos == null) {
                pos = new Double[3];
                lastPositions.put(p, pos);
            }
            try {
                if ((pos[0] != p.field_70165_t || pos[2] != p.field_70161_v) && (Math.abs(p.field_70165_t) > 2.7E7 || Math.abs(p.field_70161_v) > 2.7E7)) {
                    p.func_184595_k(pos[0].doubleValue(), pos[1].doubleValue(), pos[2].doubleValue());
                    p.func_145747_a((ITextComponent)new TextComponentString("You can't go beyond 27000000 blocks because airships are stored there!"));
                }
            }
            catch (NullPointerException e) {
                ValkyrienWarfareMod.VWLogger.log(Level.WARNING, "Nullpointer EventsCommon.java:onPlayerTickEvent");
            }
            pos[0] = p.field_70165_t;
            pos[1] = p.field_70163_u;
            pos[2] = p.field_70161_v;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        ValkyrienWarfareMod.physicsManager.initWorld(world);
        world.func_72954_a((IWorldEventListener)new ValkyrienWarfareWorldEventListener(world));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            ValkyrienWarfareMod.chunkManager.removeWorld(event.getWorld());
        } else {
            lastPositions.clear();
        }
        ValkyrienWarfareMod.physicsManager.removeWorld(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChunkNBTLoad(ChunkDataEvent.Load event) {
        NBTTagCompound data = event.getData();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChunkNBTUnload(ChunkDataEvent.Save event) {
        NBTTagCompound data = event.getData();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityUntrack(PlayerEvent.StopTracking event) {
        Entity ent;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && (ent = event.getTarget()) instanceof PhysicsWrapperEntity) {
            ((PhysicsWrapperEntity)ent).wrapping.onPlayerUntracking(event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        BlockPos pos = event.getPos();
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(event.getWorld(), pos);
        if (wrapper != null) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerOpenContainerEvent(PlayerContainerEvent event) {
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvestCheck(PlayerEvent.HarvestCheck event) {
    }

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(new ResourceLocation("valkyrienwarfare", "AirshipCounter"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagIntArray>(){
                IAirshipCounterCapability inst = (IAirshipCounterCapability)ValkyrienWarfareMod.airshipCounter.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == ValkyrienWarfareMod.airshipCounter;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == ValkyrienWarfareMod.airshipCounter ? ValkyrienWarfareMod.airshipCounter.cast((Object)this.inst) : null);
                }

                public NBTTagIntArray serializeNBT() {
                    return (NBTTagIntArray)ValkyrienWarfareMod.airshipCounter.getStorage().writeNBT(ValkyrienWarfareMod.airshipCounter, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagIntArray nbt) {
                    if (nbt instanceof NBTTagIntArray) {
                        ValkyrienWarfareMod.airshipCounter.getStorage().readNBT(ValkyrienWarfareMod.airshipCounter, (Object)this.inst, null, (NBTBase)nbt);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            lastPositions.put((EntityPlayerMP)event.player, new Double[]{0.0, 256.0, 0.0});
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (player.func_70005_c_().equals("Drake_Eldridge") || player.func_145748_c_().equals("Drake_Eldridge")) {
                WorldServer server = (WorldServer)event.player.field_70170_p;
                if (Math.random() < 0.01) {
                    player.func_70107_b(player.field_70165_t, 696969.0, player.field_70161_v);
                    server.field_73061_a.func_184103_al().func_148539_a((ITextComponent)new TextComponentString("Cheers m8!"));
                }
                server.field_73061_a.func_184103_al().func_148539_a((ITextComponent)new TextComponentString("DEL is a very special boy, and this annoying greeting is made just for him"));
                for (int i = 0; i < 3; ++i) {
                    server.field_73061_a.func_184103_al().func_148539_a((ITextComponent)new TextComponentString("VW Version Alpha Beta (Outdated)"));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            lastPositions.remove((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PhysicsWrapperEntity physObj;
        if (!event.getWorld().field_72995_K && (physObj = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(event.getWorld(), event.getPos())) != null) {
            if (ValkyrienWarfareMod.runAirshipPermissions && !physObj.wrapping.creator.equals(event.getEntityPlayer().field_96093_i.toString()) && !physObj.wrapping.allowedUsers.contains(event.getEntityPlayer().field_96093_i.toString())) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("You need to be added to the airship to do that!" + (physObj.wrapping.creator == null || physObj.wrapping.creator.trim().isEmpty() ? " Try using \"/airshipSettings claim\"!" : "")));
                event.setCanceled(true);
                return;
            }
            event.setResult(Event.Result.ALLOW);
            event.setCanceled(false);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        PhysicsWrapperEntity physObj;
        if (!event.getWorld().field_72995_K && (physObj = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(event.getWorld(), event.getPos())) != null) {
            if (ValkyrienWarfareMod.runAirshipPermissions && !physObj.wrapping.creator.equals(event.getPlayer().field_96093_i.toString()) && !physObj.wrapping.allowedUsers.contains(event.getPlayer().field_96093_i.toString())) {
                event.getPlayer().func_145747_a((ITextComponent)new TextComponentString("You need to be added to the airship to do that!" + (physObj.wrapping.creator == null || physObj.wrapping.creator.trim().isEmpty() ? " Try using \"/airshipSettings claim\"!" : "")));
                event.setCanceled(true);
                return;
            }
            if (physObj.wrapping.shipType == ShipType.Oribtal) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public void onPlaceEvent(BlockEvent.PlaceEvent event) {
        PhysicsWrapperEntity physObj = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(event.getWorld(), event.getPos());
        if (physObj != null) {
            if (ValkyrienWarfareMod.runAirshipPermissions && !physObj.wrapping.creator.equals(event.getPlayer().field_96093_i.toString()) && !physObj.wrapping.allowedUsers.contains(event.getPlayer().field_96093_i.toString())) {
                event.getPlayer().func_145747_a((ITextComponent)new TextComponentString("You need to be added to the airship to do that!" + (physObj.wrapping.creator == null || physObj.wrapping.creator.trim().isEmpty() ? " Try using \"/airshipSettings claim\"!" : "")));
                event.setCanceled(true);
                return;
            }
            if (physObj.wrapping.shipType == ShipType.Oribtal) {
                event.setCanceled(true);
            }
        }
    }
}

