/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.api.Vector;

public class NBTUtils {
    public static final void writeBlockPosToNBT(String name, BlockPos pos, NBTTagCompound compound) {
        compound.func_74768_a(name + "X", pos.func_177958_n());
        compound.func_74768_a(name + "Y", pos.func_177956_o());
        compound.func_74768_a(name + "Z", pos.func_177952_p());
    }

    public static final BlockPos readBlockPosFromNBT(String name, NBTTagCompound compound) {
        int x = compound.func_74762_e(name + "X");
        int y = compound.func_74762_e(name + "Y");
        int z = compound.func_74762_e(name + "Z");
        return new BlockPos(x, y, z);
    }

    public static final void writeBlockPosArrayListToNBT(String name, ArrayList<BlockPos> posArray, NBTTagCompound compound) {
        int[] xArray = new int[posArray.size()];
        int[] yArray = new int[posArray.size()];
        int[] zArray = new int[posArray.size()];
        for (int i = 0; i < posArray.size(); ++i) {
            BlockPos pos = posArray.get(i);
            xArray[i] = pos.func_177958_n();
            yArray[i] = pos.func_177956_o();
            zArray[i] = pos.func_177952_p();
        }
        compound.func_74783_a(name + "xArray", xArray);
        compound.func_74783_a(name + "yArray", yArray);
        compound.func_74783_a(name + "zArray", zArray);
    }

    public static final ArrayList<BlockPos> readBlockPosArrayListFromNBT(String name, NBTTagCompound compound) {
        int[] xArray = compound.func_74759_k(name + "xArray");
        int[] yArray = compound.func_74759_k(name + "yArray");
        int[] zArray = compound.func_74759_k(name + "zArray");
        ArrayList<BlockPos> posArray = new ArrayList<BlockPos>(xArray.length + 10);
        for (int i = 0; i < xArray.length; ++i) {
            BlockPos pos = new BlockPos(xArray[i], yArray[i], zArray[i]);
            posArray.add(pos);
        }
        return posArray;
    }

    public static final void write3x3MatrixToNBT(String name, double[] matrix, NBTTagCompound compound) {
        for (int i = 0; i < 9; ++i) {
            compound.func_74780_a(name + i, matrix[i]);
        }
    }

    public static final double[] read3x3MatrixFromNBT(String name, NBTTagCompound compound) {
        double[] matrix = new double[9];
        for (int i = 0; i < 9; ++i) {
            matrix[i] = compound.func_74769_h(name + i);
        }
        return matrix;
    }

    public static final void writeVectorToNBT(String name, Vector vector, NBTTagCompound compound) {
        compound.func_74780_a(name + "X", vector.X);
        compound.func_74780_a(name + "Y", vector.Y);
        compound.func_74780_a(name + "Z", vector.Z);
    }

    public static final Vector readVectorFromNBT(String name, NBTTagCompound compound) {
        Vector vector = new Vector();
        vector.X = compound.func_74769_h(name + "X");
        vector.Y = compound.func_74769_h(name + "Y");
        vector.Z = compound.func_74769_h(name + "Z");
        return vector;
    }

    public static final void writeEntityPositionHashMapToNBT(String name, HashMap<Integer, Vector> entityLocalPositions, NBTTagCompound compound) {
        int[] entityIds = new int[entityLocalPositions.size()];
        double[] entityX = new double[entityLocalPositions.size()];
        double[] entityY = new double[entityLocalPositions.size()];
        double[] entityZ = new double[entityLocalPositions.size()];
        Iterator<Map.Entry<Integer, Vector>> inputs = entityLocalPositions.entrySet().iterator();
        int cont = 0;
        while (inputs.hasNext()) {
            Map.Entry<Integer, Vector> currentEntry = inputs.next();
            entityIds[cont] = currentEntry.getKey();
            Vector vec = currentEntry.getValue();
            entityX[cont] = vec.X;
            entityY[cont] = vec.Y;
            entityZ[cont] = vec.Z;
            ++cont;
        }
        compound.func_74783_a(name + "keys", entityIds);
        compound.func_74773_a(name + "valX", NBTUtils.toByteArray(entityX));
        compound.func_74773_a(name + "valY", NBTUtils.toByteArray(entityY));
        compound.func_74773_a(name + "valZ", NBTUtils.toByteArray(entityZ));
    }

    public static final HashMap<Integer, Vector> readEntityPositionMap(String name, NBTTagCompound compound) {
        int[] entityIds = compound.func_74759_k(name + "keys");
        double[] entityX = NBTUtils.toDoubleArray(compound.func_74770_j(name + "valX"));
        double[] entityY = NBTUtils.toDoubleArray(compound.func_74770_j(name + "valY"));
        double[] entityZ = NBTUtils.toDoubleArray(compound.func_74770_j(name + "valZ"));
        HashMap<Integer, Vector> toReturn = new HashMap<Integer, Vector>(entityIds.length + 1);
        for (int i = 0; i < entityIds.length; ++i) {
            toReturn.put(entityIds[i], new Vector(entityX[i], entityY[i], entityZ[i]));
        }
        return toReturn;
    }

    public static byte[] toByteArray(double[] doubleArray) {
        int times = 8;
        byte[] bytes = new byte[doubleArray.length * times];
        for (int i = 0; i < doubleArray.length; ++i) {
            ByteBuffer.wrap(bytes, i * times, times).putDouble(doubleArray[i]);
        }
        return bytes;
    }

    public static double[] toDoubleArray(byte[] byteArray) {
        int times = 8;
        double[] doubles = new double[byteArray.length / times];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(byteArray, i * times, times).getDouble();
        }
        return doubles;
    }

    public static byte[] toByteArray(int[] intArray) {
        int times = 4;
        byte[] bytes = new byte[intArray.length * times];
        for (int i = 0; i < intArray.length; ++i) {
            ByteBuffer.wrap(bytes, i * times, times).putInt(intArray[i]);
        }
        return bytes;
    }

    public static int[] toIntArray(byte[] byteArray) {
        int times = 4;
        int[] doubles = new int[byteArray.length / times];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(byteArray, i * times, times).getInt();
        }
        return doubles;
    }

    public static void setByteBuf(String name, ByteBuffer buffer, NBTTagCompound compound) {
        byte[] bytes = buffer.array();
        compound.func_74773_a(name, bytes);
    }

    public static ByteBuffer getByteBuf(String name, NBTTagCompound compound) {
        byte[] bytes = compound.func_74770_j(name);
        ByteBuffer toReturn = ByteBuffer.wrap(bytes);
        return toReturn;
    }
}

