/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import valkyrienwarfare.BlockPhysicsRegistration;
import valkyrienwarfare.ModCommands;
import valkyrienwarfare.PhysicsSettings;
import valkyrienwarfare.RealMethods;
import valkyrienwarfare.VWChunkLoadingCallback;
import valkyrienwarfare.addon.combat.ValkyrienWarfareCombat;
import valkyrienwarfare.addon.control.ValkyrienWarfareControl;
import valkyrienwarfare.addon.world.ValkyrienWarfareWorld;
import valkyrienwarfare.api.DataTag;
import valkyrienwarfare.api.ValkyrienWarfareHooks;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.api.addons.Module;
import valkyrienwarfare.api.addons.VWAddon;
import valkyrienwarfare.block.BlockPhysicsInfuser;
import valkyrienwarfare.block.BlockPhysicsInfuserCreative;
import valkyrienwarfare.capability.IAirshipCounterCapability;
import valkyrienwarfare.capability.ImplAirshipCounterCapability;
import valkyrienwarfare.capability.StorageAirshipCounter;
import valkyrienwarfare.chunkmanagement.DimensionPhysicsChunkManager;
import valkyrienwarfare.gui.TabValkyrienWarfare;
import valkyrienwarfare.mixin.MixinLoaderForge;
import valkyrienwarfare.network.EntityRelativePositionMessage;
import valkyrienwarfare.network.EntityRelativePositionMessageHandler;
import valkyrienwarfare.network.PhysWrapperPositionHandler;
import valkyrienwarfare.network.PhysWrapperPositionMessage;
import valkyrienwarfare.network.PlayerShipRefrenceHandler;
import valkyrienwarfare.network.PlayerShipRefrenceMessage;
import valkyrienwarfare.physicsmanagement.DimensionPhysObjectManager;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.proxy.CommonProxy;
import valkyrienwarfare.proxy.ServerProxy;

@Mod(modid="valkyrienwarfare", name="Valkyrien Warfare", version="0.9_alpha", guiFactory="valkyrienwarfare.gui.GuiFactoryValkyrienWarfare", updateJSON="https://raw.githubusercontent.com/BigBastard/Valkyrien-Warfare-Revamped/update.json")
public class ValkyrienWarfareMod {
    public static final ArrayList<Module> addons = new ArrayList();
    public static final String MODID = "valkyrienwarfare";
    public static final String MODNAME = "Valkyrien Warfare";
    public static final String MODVER = "0.9_alpha";
    @CapabilityInject(value=IAirshipCounterCapability.class)
    public static final Capability<IAirshipCounterCapability> airshipCounter = null;
    public static final ExecutorService MultiThreadExecutor = Executors.newWorkStealingPool();
    public static final ExecutorService PhysicsMasterThread = Executors.newCachedThreadPool();
    @SidedProxy(clientSide="valkyrienwarfare.proxy.ClientProxy", serverSide="valkyrienwarfare.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static File configFile;
    public static Configuration config;
    public static boolean dynamicLighting;
    public static boolean multiThreadedPhysics;
    public static boolean doSplitting;
    public static boolean doShipCollision;
    public static boolean shipsSpawnParticles;
    public static Vector gravity;
    public static int physIter;
    public static double physSpeed;
    public static Block physicsInfuser;
    public static Block physicsInfuserCreative;
    public static SimpleNetworkWrapper physWrapperNetwork;
    public static DimensionPhysicsChunkManager chunkManager;
    public static DimensionPhysObjectManager physicsManager;
    public static CreativeTabs vwTab;
    @Mod.Instance(value="valkyrienwarfare")
    public static ValkyrienWarfareMod INSTANCE;
    public static int airStateIndex;
    public static double standingTolerance;
    public static int maxShipSize;
    public static double shipUpperLimit;
    public static double shipLowerLimit;
    public static int maxAirships;
    public static boolean highAccuracyCollisions;
    public static boolean accurateRain;
    public static boolean runAirshipPermissions;
    public static double shipmobs_spawnrate;
    public static Logger VWLogger;
    private static boolean hasAddonRegistrationEnded;
    public DataTag tag = null;

    public static void applyConfig(Configuration conf) {
        multiThreadedPhysics = config.get("general", "Multi-Threaded physics", true, "Use Multi-Threaded physics").getBoolean();
        doShipCollision = config.get("general", "Enable Ship collision", true).getBoolean();
        shipUpperLimit = config.get("general", "Ship Y-Height Maximum", 1000.0).getDouble();
        shipLowerLimit = config.get("general", "Ship Y-Height Minimum", -30.0).getDouble();
        maxAirships = config.get("general", "Max airships per player", -1, "Players can't own more than this many airships at once. Set to -1 to disable.").getInt();
        accurateRain = config.get("general", "Enable accurate rain on ships", false, "Debug feature, takes a lot of processing power").getBoolean();
        shipsSpawnParticles = config.get("general", "Enable particle spawns on Ships", true, "Ex. Torch Particles").getBoolean();
        runAirshipPermissions = config.get("general", "Enable airship permissions", false, "Enables the airship permissions system").getBoolean();
        shipmobs_spawnrate = config.get("general", "The spawn rate for ship mobs", 0.01, "The spawn rate for ship mobs").getDouble();
    }

    public static File getWorkingFolder() {
        try {
            File toBeReturned = FMLCommonHandler.instance().getSide().isClient() ? Minecraft.func_71410_x().field_71412_D : FMLCommonHandler.instance().getMinecraftServerInstance().func_71209_f("");
            return toBeReturned;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean canChangeAirshipCounter(boolean isAdding, EntityPlayer player) {
        if (isAdding) {
            if (maxAirships == -1) {
                return true;
            }
            return ((IAirshipCounterCapability)player.getCapability(airshipCounter, null)).getAirshipCount() < maxAirships;
        }
        return ((IAirshipCounterCapability)player.getCapability(airshipCounter, null)).getAirshipCount() > 0;
    }

    public static void registerBlock(Block block) {
        GameRegistry.register((IForgeRegistryEntry)block);
        ValkyrienWarfareMod.registerItemBlock(block);
    }

    public static void registerItemBlock(Block block) {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    public static void registerAddon(Module module) {
        if (hasAddonRegistrationEnded) {
            throw new IllegalStateException("Attempting to register addon after FMLConstructionEvent");
        }
        System.out.println("[VW Addon System] Registering addon: " + module.getClass().getCanonicalName());
        for (Module registered : addons) {
            if (!registered.getClass().getCanonicalName().equals(module.getClass().getCanonicalName())) continue;
            System.out.println("Addon " + module.getClass().getCanonicalName() + " already registered, skipping...");
            return;
        }
        addons.add(module);
    }

    @Mod.EventHandler
    public void fmlConstruct(FMLConstructionEvent event) {
        URLClassLoader classLoader = (URLClassLoader)this.getClass().getClassLoader();
        ArrayList<String> allAddons = new ArrayList<String>();
        boolean isAddonBugFixed = false;
        ValkyrienWarfareCombat combatModule = new ValkyrienWarfareCombat();
        ValkyrienWarfareControl controlModule = new ValkyrienWarfareControl();
        ValkyrienWarfareWorld worldModule = new ValkyrienWarfareWorld();
        ValkyrienWarfareMod.registerAddon(combatModule);
        ValkyrienWarfareMod.registerAddon(controlModule);
        ValkyrienWarfareMod.registerAddon(worldModule);
        if (!MixinLoaderForge.isObfuscatedEnvironment) {
            // empty if block
        }
        for (URL url : classLoader.getURLs()) {
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(new File(url.getPath()))));
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().startsWith("vwAddon_")) continue;
                    try {
                        ZipFile file = new ZipFile(new File(url.getPath()));
                        InputStream inputStream = file.getInputStream(file.getEntry(entry.getName()));
                        Scanner scanner = new Scanner(inputStream);
                        while (scanner.hasNextLine()) {
                            String className = scanner.nextLine().trim();
                            allAddons.add(className);
                            System.out.println("Found addon " + className);
                        }
                        scanner.close();
                        inputStream.close();
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                        break;
                    }
                }
                zis.close();
            }
            catch (IOException zis) {
                // empty catch block
            }
        }
        block9: for (String className : allAddons) {
            try {
                Class<?> abstractclass = Class.forName(className);
                if (abstractclass.isAnnotationPresent(VWAddon.class)) {
                    for (Module registered : addons) {
                        if (!registered.getClass().getCanonicalName().equals(abstractclass.getCanonicalName())) continue;
                        System.out.println("Addon " + abstractclass.getCanonicalName() + " already registered, skipping...");
                        continue block9;
                    }
                    Module module = (Module)abstractclass.newInstance();
                    ValkyrienWarfareMod.registerAddon(module);
                    continue;
                }
                System.out.println("Class " + className + " does not have @VWAddon annonation, not loading");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                System.out.println("Not loading addon: " + className);
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        hasAddonRegistrationEnded = true;
        proxy.preInit(event);
        this.registerBlocks((FMLStateEvent)event);
        this.registerRecipies((FMLStateEvent)event);
        this.registerNetworks((FMLStateEvent)event);
        this.runConfiguration(event);
        this.registerCapibilities();
        ValkyrienWarfareHooks.methods = new RealMethods();
        ValkyrienWarfareHooks.isValkyrienWarfareInstalled = true;
        VWLogger = Logger.getLogger("ValkyrienWarfare");
        for (Module addon : addons) {
            addon.doPreInit((FMLStateEvent)event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "PhysWrapper"), PhysicsWrapperEntity.class, (String)"PhysWrapper", (int)70, (Object)this, (int)120, (int)1, (boolean)false);
        for (Module addon : addons) {
            addon.doInit((FMLStateEvent)event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        airStateIndex = Block.func_176210_f((IBlockState)Blocks.field_150350_a.func_176223_P());
        BlockPhysicsRegistration.registerCustomBlockMasses();
        BlockPhysicsRegistration.registerVanillaBlockForces();
        BlockPhysicsRegistration.registerBlocksToNotPhysicise();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, (ForgeChunkManager.LoadingCallback)new VWChunkLoadingCallback());
        try {
            Field ticketConstraintsField = ForgeChunkManager.class.getDeclaredField("ticketConstraints");
            Field chunkConstraintsField = ForgeChunkManager.class.getDeclaredField("chunkConstraints");
            ticketConstraintsField.setAccessible(true);
            chunkConstraintsField.setAccessible(true);
            Object ticketConstraints = ticketConstraintsField.get(null);
            Object chunkConstraints = chunkConstraintsField.get(null);
            Map ticketsMap = (Map)ticketConstraints;
            Map chunksMap = (Map)chunkConstraints;
            ticketsMap.put(MODID, Integer.MAX_VALUE);
            chunksMap.put(MODID, Integer.MAX_VALUE);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("DAMMIT LEX!");
        }
        for (Module addon : addons) {
            addon.doPostInit((FMLStateEvent)event);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ModCommands.registerCommands(server);
    }

    private void registerNetworks(FMLStateEvent event) {
        physWrapperNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("physChannel");
        physWrapperNetwork.registerMessage(PhysWrapperPositionHandler.class, PhysWrapperPositionMessage.class, 0, Side.CLIENT);
        physWrapperNetwork.registerMessage(PlayerShipRefrenceHandler.class, PlayerShipRefrenceMessage.class, 1, Side.SERVER);
        physWrapperNetwork.registerMessage(EntityRelativePositionMessageHandler.class, EntityRelativePositionMessage.class, 2, Side.CLIENT);
    }

    private void registerBlocks(FMLStateEvent event) {
        physicsInfuser = ((Block)new BlockPhysicsInfuser(Material.field_151576_e).func_149711_c(12.0f).func_149663_c("shipblock").setRegistryName(MODID, "shipblock")).func_149647_a(vwTab);
        physicsInfuserCreative = ((Block)new BlockPhysicsInfuserCreative(Material.field_151576_e).func_149711_c(12.0f).func_149663_c("shipblockcreative").setRegistryName(MODID, "shipblockcreative")).func_149647_a(vwTab);
        ValkyrienWarfareMod.registerBlock(physicsInfuser);
        ValkyrienWarfareMod.registerBlock(physicsInfuserCreative);
    }

    private void registerRecipies(FMLStateEvent event) {
        GameRegistry.addRecipe((ItemStack)new ItemStack(physicsInfuser), (Object[])new Object[]{"IEI", "ODO", "IEI", Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('O'), Item.func_150898_a((Block)Blocks.field_150343_Z), Character.valueOf('I'), Items.field_151042_j});
    }

    private void runConfiguration(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        config = new Configuration(configFile);
        config.load();
        ValkyrienWarfareMod.applyConfig(config);
        config.save();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        this.loadConfig();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.saveConfig();
    }

    public void loadConfig() {
        File file = new File(ValkyrienWarfareMod.getWorkingFolder(), "/valkyrienwarfaresettings.dat");
        if (!file.exists()) {
            this.tag = new DataTag(file);
            this.tag.setBoolean("doGravity", true);
            this.tag.setBoolean("doPhysicsBlocks", true);
            this.tag.setBoolean("doBalloons", true);
            this.tag.setBoolean("doAirshipRotation", true);
            this.tag.setBoolean("doAirshipMovement", true);
            this.tag.setBoolean("doSplitting", false);
            this.tag.setInteger("maxShipSize", 15000);
            this.tag.setDouble("gravityVecX", 0.0);
            this.tag.setDouble("gravityVecY", -9.8);
            this.tag.setDouble("gravityVecZ", 0.0);
            this.tag.setInteger("physicsIterations", 10);
            this.tag.setDouble("physicsSpeed", 0.05);
            this.tag.setBoolean("doEtheriumLifting", true);
            this.tag.save();
        } else {
            this.tag = new DataTag(file);
        }
        PhysicsSettings.doGravity = this.tag.getBoolean("doGravity", true);
        PhysicsSettings.doPhysicsBlocks = this.tag.getBoolean("doPhysicsBlocks", true);
        PhysicsSettings.doBalloons = this.tag.getBoolean("doBalloons", true);
        PhysicsSettings.doAirshipRotation = this.tag.getBoolean("doAirshipRotation", true);
        PhysicsSettings.doAirshipMovement = this.tag.getBoolean("doAirshipMovement", true);
        doSplitting = this.tag.getBoolean("doSplitting", false);
        maxShipSize = this.tag.getInteger("maxShipSize", 15000);
        physIter = this.tag.getInteger("physicsIterations", 8);
        physSpeed = this.tag.getDouble("physicsSpeed", 0.05);
        gravity = new Vector(this.tag.getDouble("gravityVecX", 0.0), this.tag.getDouble("gravityVecY", -9.8), this.tag.getDouble("gravityVecZ", 0.0));
        PhysicsSettings.doEtheriumLifting = this.tag.getBoolean("doEtheriumLifting", true);
        this.tag.save();
    }

    public void saveConfig() {
        this.tag.setBoolean("doGravity", PhysicsSettings.doGravity);
        this.tag.setBoolean("doPhysicsBlocks", PhysicsSettings.doPhysicsBlocks);
        this.tag.setBoolean("doBalloons", PhysicsSettings.doBalloons);
        this.tag.setBoolean("doAirshipRotation", PhysicsSettings.doAirshipRotation);
        this.tag.setBoolean("doAirshipMovement", PhysicsSettings.doAirshipMovement);
        this.tag.setBoolean("doSplitting", doSplitting);
        this.tag.setInteger("maxShipSize", maxShipSize);
        this.tag.setDouble("gravityVecX", ValkyrienWarfareMod.gravity.X);
        this.tag.setDouble("gravityVecY", ValkyrienWarfareMod.gravity.Y);
        this.tag.setDouble("gravityVecZ", ValkyrienWarfareMod.gravity.Z);
        this.tag.setInteger("physicsIterations", physIter);
        this.tag.setDouble("physicsSpeed", physSpeed);
        this.tag.save();
    }

    public void registerCapibilities() {
        CapabilityManager.INSTANCE.register(IAirshipCounterCapability.class, (Capability.IStorage)new StorageAirshipCounter(), ImplAirshipCounterCapability.class);
    }

    public boolean isRunningOnClient() {
        return !(proxy instanceof ServerProxy);
    }

    static {
        doSplitting = false;
        doShipCollision = false;
        shipsSpawnParticles = false;
        gravity = new Vector(0.0, -9.8, 0.0);
        physIter = 10;
        physSpeed = 0.05;
        vwTab = new TabValkyrienWarfare();
        INSTANCE = new ValkyrienWarfareMod();
        standingTolerance = 0.42;
        maxShipSize = 15000;
        shipUpperLimit = 1000.0;
        shipLowerLimit = -30.0;
        maxAirships = -1;
        highAccuracyCollisions = false;
        accurateRain = false;
        runAirshipPermissions = false;
        shipmobs_spawnrate = 0.01;
        hasAddonRegistrationEnded = false;
    }
}

