/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.combat.entity;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import valkyrienwarfare.api.Vector;

public class EntityCannonBall
extends Entity {
    public float explosionPower;
    private int lerpSteps;
    private double boatPitch;
    private double lerpY;
    private double lerpZ;
    private double lerpXRot;
    private double boatYaw;

    public EntityCannonBall(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.4f);
        this.explosionPower = 2.0f;
    }

    public EntityCannonBall(World worldIn, Vector velocityVector, Entity parent) {
        this(worldIn);
        this.field_70159_w = velocityVector.X;
        this.field_70181_x = velocityVector.Y;
        this.field_70179_y = velocityVector.Z;
        this.field_70126_B = this.field_70177_z = parent.field_70177_z;
        this.field_70127_C = this.field_70125_A = parent.field_70125_A;
        this.field_70142_S = this.field_70165_t = parent.field_70165_t;
        this.field_70169_q = this.field_70165_t;
        this.field_70137_T = this.field_70163_u = parent.field_70163_u;
        this.field_70167_r = this.field_70163_u;
        this.field_70136_U = this.field_70161_v = parent.field_70161_v;
        this.field_70166_s = this.field_70161_v;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickLerp();
        this.processMovementForTick();
    }

    private void processMovementForTick() {
        Vec3d origin = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d traceEnd = origin.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        RayTraceResult traceResult = this.field_70170_p.func_147447_a(origin, traceEnd, false, true, false);
        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            double drag = Math.pow(0.995, 0.05);
            this.field_70159_w *= drag;
            this.field_70181_x *= drag;
            this.field_70179_y *= drag;
            this.field_70181_x -= 0.05;
        } else if (traceResult.field_72307_f != null && !this.field_70170_p.field_72995_K) {
            this.processCollision(traceResult);
            this.func_70106_y();
        }
    }

    private void processCollision(RayTraceResult collisionTrace) {
        this.field_70170_p.func_72876_a((Entity)this, collisionTrace.field_72307_f.field_72450_a, collisionTrace.field_72307_f.field_72448_b, collisionTrace.field_72307_f.field_72449_c, this.explosionPower, true);
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.boatPitch - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

