/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.combat.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import valkyrienwarfare.addon.combat.ValkyrienWarfareCombat;
import valkyrienwarfare.addon.combat.entity.EntityCannonBall;
import valkyrienwarfare.addon.combat.entity.EntityMountingWeaponBase;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.fixes.IInventoryPlayerFix;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class EntityCannonBasic
extends EntityMountingWeaponBase {
    int tickDelay = 6;
    boolean isCannonLoaded = false;

    public EntityCannonBasic(World worldIn) {
        super(worldIn);
    }

    @Override
    public void onRiderInteract(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && this.canPlayerInteract(player, stack, hand)) {
            this.fireCannon(player, stack, hand);
        }
    }

    public void fireCannon(EntityPlayer player, ItemStack stack, EnumHand hand) {
        Vec3d velocityNormal = this.func_174806_f(this.field_70125_A, this.field_70177_z);
        Vector velocityVector = new Vector(velocityNormal);
        PhysicsWrapperEntity wrapper = this.getParentShip();
        velocityVector.multiply(3.0);
        EntityCannonBall projectile = new EntityCannonBall(this.field_70170_p, velocityVector, this);
        Vector projectileSpawnPos = new Vector(0.0, 0.5, 0.0);
        if (wrapper != null) {
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWRotation, projectileSpawnPos);
        }
        projectile.field_70165_t += projectileSpawnPos.X;
        projectile.field_70163_u += projectileSpawnPos.Y;
        projectile.field_70161_v += projectileSpawnPos.Z;
        this.field_70170_p.func_72838_d((Entity)projectile);
        this.isCannonLoaded = false;
    }

    public boolean canPlayerInteract(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (this.currentTicksOperated < 0) {
            ++this.currentTicksOperated;
            return false;
        }
        if (!this.isCannonLoaded) {
            ItemStack cannonBallStack = new ItemStack(ValkyrienWarfareCombat.INSTANCE.cannonBall);
            ItemStack powderStack = new ItemStack(ValkyrienWarfareCombat.INSTANCE.powderPouch);
            boolean hasCannonBall = player.field_71071_by.func_70431_c(cannonBallStack);
            boolean hasPowder = player.field_71071_by.func_70431_c(powderStack);
            if (hasCannonBall && hasPowder || player.func_184812_l_()) {
                for (NonNullList<ItemStack> aitemstack : IInventoryPlayerFix.getFixFromInventory(player.field_71071_by).getAllInventories()) {
                    for (ItemStack itemstack : aitemstack) {
                        int index;
                        int itemStackSize;
                        if (itemstack != null && itemstack.func_77969_a(cannonBallStack)) {
                            itemStackSize = itemstack.func_190916_E();
                            itemstack.func_190920_e(itemStackSize - 1);
                            if (itemstack.func_190916_E() <= 0) {
                                index = player.field_71071_by.func_184429_b(itemstack);
                                player.field_71071_by.func_70299_a(index, ItemStack.field_190927_a);
                            }
                        }
                        if (itemstack == null || !itemstack.func_77969_a(powderStack)) continue;
                        itemStackSize = itemstack.func_190916_E();
                        itemstack.func_190920_e(itemStackSize - 1);
                        if (itemstack.func_190916_E() > 0) continue;
                        index = player.field_71071_by.func_184429_b(itemstack);
                        player.field_71071_by.func_70299_a(index, null);
                    }
                }
                this.isCannonLoaded = true;
            }
        } else {
            ++this.currentTicksOperated;
            if (this.currentTicksOperated > this.tickDelay) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void doItemDrops() {
        ItemStack itemstack = new ItemStack(ValkyrienWarfareCombat.INSTANCE.basicCannonSpawner, 1);
        if (this.func_70005_c_() != null) {
            itemstack.func_151001_c(this.func_70005_c_());
        }
        this.func_70099_a(itemstack, 0.0f);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.isCannonLoaded = tagCompund.func_74767_n("isCannonLoaded");
    }

    @Override
    protected void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("isCannonLoaded", this.isCannonLoaded);
    }
}

