/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.combat.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public abstract class EntityMountingWeaponBase
extends Entity
implements IEntityAdditionalSpawnData {
    public int currentTicksOperated = 0;
    public double damage = 0.0;
    private EnumFacing facing = EnumFacing.NORTH;

    public EntityMountingWeaponBase(World worldIn) {
        super(worldIn);
        this.field_70130_N = 1.0f;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184208_bv() == super.func_184208_bv()) {
            this.onRiderInteract(player, player.func_184586_b(hand), hand);
        } else {
            player.func_184220_m((Entity)this);
            PhysicsWrapperEntity wrapper = this.getParentShip();
            if (wrapper != null) {
                Vector posInLocal = new Vector(this);
                Vector passengerOffset = this.getRiderPositionOffset();
                wrapper.wrapping.coordTransform.fromGlobalToLocal(posInLocal);
                posInLocal.add(passengerOffset);
                wrapper.wrapping.fixEntity((Entity)player, posInLocal);
            }
        }
        return false;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand stack) {
        return EnumActionResult.PASS;
    }

    public void setFacing(EnumFacing toSet) {
        this.facing = toSet;
        this.field_70177_z = -this.getBaseAngleOffset() + 90.0f;
    }

    public float getBaseAngleOffset() {
        switch (this.facing) {
            case WEST: {
                return 0.0f;
            }
            case SOUTH: {
                return 90.0f;
            }
            case EAST: {
                return 180.0f;
            }
            case NORTH: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public abstract void onRiderInteract(EntityPlayer var1, @Nullable ItemStack var2, EnumHand var3);

    public void func_70098_U() {
    }

    public double func_70042_X() {
        return -0.4;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public Entity func_184208_bv() {
        EntityMountingWeaponBase entity = this;
        while (entity.func_184218_aH()) {
            entity = entity.func_184187_bx();
        }
        return null;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int rotationSteps, boolean p_180426_10_) {
        if (p_180426_10_) {
            this.field_70165_t = x;
            this.field_70163_u = y;
            this.field_70161_v = z;
            this.field_70177_z = yaw;
            this.field_70125_A = pitch;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity rider = this.getRider();
        if (rider != null) {
            this.field_70177_z = rider.func_70079_am();
            this.field_70125_A = rider.field_70125_A;
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger) && this.getParentShip() == null) {
            Vector passengerOffset = this.getRiderPositionOffset();
            passengerOffset.add(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            passenger.func_70107_b(passengerOffset.X, passengerOffset.Y, passengerOffset.Z);
        }
    }

    public Vector getRiderPositionOffset() {
        Vector riderOffset = new Vector(0.55, 0.0, 0.0);
        double[] rotMatrix = RotationMatrices.getDoubleIdentity();
        rotMatrix = RotationMatrices.rotateOnly(rotMatrix, 0.0, this.getBaseAngleOffset(), 0.0);
        RotationMatrices.applyTransform(rotMatrix, riderOffset);
        riderOffset.Y += this.func_70042_X();
        return riderOffset;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.field_70121_D;
    }

    @Nullable
    public Entity getRider() {
        Entity entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        return entity;
    }

    public boolean canRiderInteract() {
        System.out.println("test");
        return true;
    }

    @Nullable
    public Entity func_184187_bx() {
        return this.field_184239_as;
    }

    protected void func_70088_a() {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (this.func_180431_b(source)) {
                return false;
            }
            this.func_70018_K();
            this.setDamage(this.getDamage() + (double)(amount * 10.0f));
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > this.getMaxDamage()) {
                this.func_184226_ay();
                if (flag && !this.func_145818_k_()) {
                    this.func_70106_y();
                } else {
                    this.killWeapon(source);
                }
            }
            return true;
        }
        return true;
    }

    public void func_70107_b(double x, double y, double z) {
        PhysicsWrapperEntity wrapper = this.getParentShip();
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double toSet) {
        this.damage = toSet;
    }

    public double getMaxDamage() {
        return 50.0;
    }

    public void killWeapon(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.doItemDrops();
        }
    }

    public abstract void doItemDrops();

    public PhysicsWrapperEntity getParentShip() {
        if (this.field_184239_as instanceof PhysicsWrapperEntity) {
            PhysicsWrapperEntity wrapper = (PhysicsWrapperEntity)this.field_184239_as;
            return wrapper;
        }
        return null;
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        this.facing = EnumFacing.func_176731_b((int)tagCompund.func_74762_e("facingOrdinal"));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("facingOrdinal", this.facing.func_176736_b());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.facing.func_176736_b());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.facing = EnumFacing.func_176731_b((int)additionalData.readInt());
    }
}

