/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.balloon;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import valkyrienwarfare.relocation.SpatialDetector;

public class BalloonDetector
extends SpatialDetector {
    public final TIntHashSet balloonWalls = new TIntHashSet(250);
    private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();

    public BalloonDetector(BlockPos start, World worldIn, int maximum) {
        super(start, worldIn, maximum, false);
        this.startDetection();
    }

    @Override
    public void calculateSpatialOccupation() {
        this.nextQueue.add(this.firstBlock.func_177956_o() + 131072 + 0x4000000);
        BlockPos.MutableBlockPos inRealWorld = new BlockPos.MutableBlockPos();
        while (!this.nextQueue.isEmpty() && !this.cleanHouse) {
            TIntIterator queueIter = this.nextQueue.iterator();
            this.foundSet.addAll((TIntCollection)this.nextQueue);
            this.nextQueue = new TIntHashSet();
            while (queueIter.hasNext()) {
                int hash = queueIter.next();
                BalloonDetector.setPosWithRespectTo(hash, this.firstBlock, inRealWorld);
                this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p(), hash + 512);
                this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p(), hash - 512);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p(), hash + 1);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o(), inRealWorld.func_177952_p() + 1, hash + 262144);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o(), inRealWorld.func_177952_p() - 1, hash - 262144);
            }
        }
    }

    @Override
    public void tryExpanding(int x, int y, int z, int hash) {
        if (this.isValidExpansion(x, y, z)) {
            if (!this.foundSet.contains(hash) && this.foundSet.size() + this.nextQueue.size() < this.maxSize) {
                this.nextQueue.add(hash);
            }
        } else if (!this.balloonWalls.contains(hash)) {
            this.balloonWalls.add(hash);
        }
    }

    @Override
    public boolean isValidExpansion(int x, int y, int z) {
        IBlockState state = this.cache.getBlockState(x, y, z);
        if (!state.func_177230_c().field_149764_J.func_76230_c()) {
            Chunk chunk = this.cache.getChunkAt(x >> 4, z >> 4);
            this.mutable.func_181079_c(x, y, z);
            if (!chunk.func_177444_d((BlockPos)this.mutable)) {
                return true;
            }
            this.cleanHouse = true;
        }
        return false;
    }
}

