/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.balloon;

import gnu.trove.iterator.TIntIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.addon.control.balloon.BalloonAirDetector;
import valkyrienwarfare.addon.control.balloon.BalloonDetector;
import valkyrienwarfare.addon.control.balloon.BalloonHoleDetector;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class BalloonProcessor {
    public PhysicsWrapperEntity parent;
    public HashSet<BlockPos> balloonWalls;
    public HashSet<BlockPos> internalAirPositions;
    public HashSet<BlockPos> balloonHoles;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public Vector currentBalloonCenter = new Vector();
    public int currentBalloonSize;
    private double balloonTemperature = 295.0;

    public BalloonProcessor(PhysicsWrapperEntity parent, HashSet<BlockPos> balloonWalls, HashSet<BlockPos> internalAirPositons) {
        this.parent = parent;
        this.balloonWalls = balloonWalls;
        this.internalAirPositions = internalAirPositons;
        this.balloonHoles = new HashSet();
        this.updateBalloonCenter();
    }

    private static BlockPos getRandomPosFromSet(HashSet<BlockPos> positions) {
        Iterator<BlockPos> iterator = positions.iterator();
        if (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            return pos;
        }
        return null;
    }

    public static BalloonProcessor makeProcessorForDetector(PhysicsWrapperEntity wrapper, BalloonDetector detector) {
        BlockPos fromHash;
        int hash;
        int maxZ;
        int maxY;
        int maxX;
        TIntIterator ballonWallIterator = detector.balloonWalls.iterator();
        TIntIterator airPostitionsIterator = detector.foundSet.iterator();
        HashSet<BlockPos> staticBalloonWalls = new HashSet<BlockPos>();
        HashSet<BlockPos> staticInternalPositions = new HashSet<BlockPos>();
        int minX = maxX = detector.firstBlock.func_177958_n();
        int minY = maxY = detector.firstBlock.func_177956_o();
        int minZ = maxZ = detector.firstBlock.func_177952_p();
        while (ballonWallIterator.hasNext()) {
            hash = ballonWallIterator.next();
            fromHash = BalloonDetector.getPosWithRespectTo(hash, detector.firstBlock);
            staticBalloonWalls.add(fromHash);
            minX = Math.min(minX, fromHash.func_177958_n());
            minY = Math.min(minY, fromHash.func_177956_o());
            minZ = Math.min(minZ, fromHash.func_177952_p());
            maxX = Math.max(maxX, fromHash.func_177958_n());
            maxY = Math.max(maxY, fromHash.func_177956_o());
            maxZ = Math.max(maxZ, fromHash.func_177952_p());
        }
        while (airPostitionsIterator.hasNext()) {
            hash = airPostitionsIterator.next();
            fromHash = BalloonDetector.getPosWithRespectTo(hash, detector.firstBlock);
            staticInternalPositions.add(fromHash);
        }
        BalloonProcessor toReturn = new BalloonProcessor(wrapper, staticBalloonWalls, staticInternalPositions);
        toReturn.minX = minX;
        toReturn.minY = minY;
        toReturn.minZ = minZ;
        toReturn.maxX = maxX;
        toReturn.maxY = maxY;
        toReturn.maxZ = maxZ;
        return toReturn;
    }

    public Vector getBalloonForce(double secondsToSimulate, PhysicsCalculations processor) {
        Vector forceVector = new Vector(processor.gravity);
        double displacedMass = Math.max(this.getBalloonAirMassAtAmbient() - this.getBalloonAirMass(), 0.0);
        forceVector.multiply(-displacedMass);
        return forceVector;
    }

    public Vector getForceCenter() {
        Vector adjustedCenter = new Vector(this.currentBalloonCenter);
        return adjustedCenter;
    }

    public void tickBalloonTemperatures(double secondsToSimulate, PhysicsCalculations processor) {
        this.balloonTemperature = 320.0;
        this.processBalloonCooling(secondsToSimulate);
    }

    private void processBalloonCooling(double secondsToSimulate) {
        for (BlockPos blockPos : this.balloonHoles) {
        }
    }

    public void addGasAtTemp(double gasMass, double gasTemp) {
        double currentMass = this.getBalloonAirMass();
        double currentTemp = this.getBalloonTemperature();
        double temperatureKg = currentMass * currentTemp + gasMass * (gasTemp - currentTemp);
        this.balloonTemperature = temperatureKg / this.getBalloonAirMass();
    }

    public double getBalloonAirMassAtAmbient() {
        double airMassAtAtmosphere = 15.25;
        return airMassAtAtmosphere * this.getAmbientPressure() * (double)this.internalAirPositions.size();
    }

    public double getBalloonAirMass() {
        double massRatio = this.getAmbientTemperature() / this.getBalloonTemperature();
        return massRatio * this.getBalloonAirMassAtAmbient();
    }

    public double getAmbientTemperature() {
        return 295.0;
    }

    public double getAmbientPressure() {
        Vector centerPos = new Vector((double)(this.minX + this.maxX) / 2.0, (double)(this.minY + this.maxY) / 2.0, (double)(this.minZ + this.maxZ) / 2.0);
        this.parent.wrapping.coordTransform.fromLocalToGlobal(centerPos);
        double yPos = centerPos.Y;
        double pressure = 60.0 / yPos;
        return Math.pow(pressure, 0.25);
    }

    public double getBalloonTemperature() {
        return this.balloonTemperature;
    }

    public void processBlockUpdates(ArrayList<BlockPos> updates) {
        for (BlockPos pos : updates) {
            if (!this.isBlockPosInRange(pos)) continue;
            IBlockState state = this.parent.wrapping.VKChunkCache.getBlockState(pos);
            Block block = state.func_177230_c();
            if (block.field_149764_J.func_76230_c()) {
                if (this.internalAirPositions.contains(pos)) {
                    this.internalAirPositions.remove(pos);
                    this.balloonWalls.add(pos);
                }
                this.balloonHoles.remove(pos);
                continue;
            }
            if (this.balloonWalls.contains(pos)) {
                this.balloonHoles.add(pos);
                continue;
            }
            if (!this.doSecondHoleCheck(pos, this.getAdjacentPositions(pos))) continue;
            this.internalAirPositions.add(pos);
        }
        if (!updates.isEmpty()) {
            this.checkBalloonForSplit();
            this.checkHolesForFixFull();
            this.updateBalloonCenter();
            this.updateBalloonRange();
        }
    }

    private void checkBalloonForSplit() {
        HashSet<BlockPos> posititionsNeedingAtatchment = new HashSet<BlockPos>();
        ArrayList<BalloonAirDetector> foundSets = new ArrayList<BalloonAirDetector>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        posititionsNeedingAtatchment.addAll(this.internalAirPositions);
        while (posititionsNeedingAtatchment.size() > 0) {
            BlockPos start = BalloonProcessor.getRandomPosFromSet(posititionsNeedingAtatchment);
            BalloonAirDetector detector = new BalloonAirDetector(start, this.parent.field_70170_p, this.currentBalloonSize, this, posititionsNeedingAtatchment);
            foundSets.add(detector);
            for (int hash : detector.foundSet) {
                BalloonAirDetector.setPosWithRespectTo(hash, start, mutable);
                posititionsNeedingAtatchment.remove(mutable);
            }
        }
        if (foundSets.size() > 1) {
            for (BalloonAirDetector split : foundSets) {
                System.out.println(split.foundSet.size());
            }
            this.processFoundSplits(foundSets);
        }
    }

    private void processFoundSplits(ArrayList<BalloonAirDetector> foundSets) {
        int maxSplitSize = -1;
        for (BalloonAirDetector split : foundSets) {
            if (split.foundSet.size() <= maxSplitSize) continue;
            maxSplitSize = split.foundSet.size();
        }
        for (BalloonAirDetector split : foundSets) {
            BlockPos pos;
            int hash;
            if (split.foundSet.size() == maxSplitSize) continue;
            TIntIterator airIterator = split.foundSet.iterator();
            TIntIterator wallIterator = split.foundBalloonWalls.iterator();
            while (airIterator.hasNext()) {
                hash = airIterator.next();
                pos = BalloonAirDetector.getPosWithRespectTo(hash, split.firstBlock);
                this.internalAirPositions.remove(pos);
                this.balloonHoles.remove(pos);
            }
            while (wallIterator.hasNext()) {
                hash = wallIterator.next();
                pos = BalloonAirDetector.getPosWithRespectTo(hash, split.firstBlock);
                this.balloonWalls.add(pos);
                this.internalAirPositions.remove(pos);
                this.balloonHoles.remove(pos);
            }
        }
    }

    public void checkHolesForFixFull() {
        ArrayList<BlockPos> balloonHoleCopy = new ArrayList<BlockPos>(this.balloonHoles);
        for (BlockPos pos : balloonHoleCopy) {
            BlockPos[] adjacentPositions = this.getAdjacentPositions(pos);
            if (!this.balloonHoles.contains(pos)) continue;
            if (this.doFirstHoleCheck(pos, adjacentPositions)) {
                this.removeHole(pos);
                continue;
            }
            if (this.doSecondHoleCheck(pos, adjacentPositions)) {
                this.removeHole(pos);
                continue;
            }
            if (!this.doLastHoleCheck(pos, adjacentPositions)) continue;
            this.removeHole(pos);
        }
    }

    public void checkHolesForFixPartial() {
        ArrayList<BlockPos> balloonHoleCopy = new ArrayList<BlockPos>(this.balloonHoles);
        for (BlockPos pos : balloonHoleCopy) {
            BlockPos[] adjacentPositions = this.getAdjacentPositions(pos);
            if (!this.balloonHoles.contains(pos)) continue;
            if (this.doFirstHoleCheck(pos, adjacentPositions)) {
                this.removeHole(pos);
                continue;
            }
            if (!this.doSecondHoleCheck(pos, adjacentPositions)) continue;
            this.removeHole(pos);
        }
    }

    private void removeHole(BlockPos holePosition) {
        this.balloonHoles.remove(holePosition);
    }

    private boolean doFirstHoleCheck(BlockPos holeToCheck, BlockPos[] adjacentPositions) {
        for (BlockPos nearbyPosition : adjacentPositions) {
            if (!this.internalAirPositions.contains(nearbyPosition)) continue;
            return false;
        }
        return true;
    }

    private boolean doSecondHoleCheck(BlockPos holeToCheck, BlockPos[] adjacentPositions) {
        for (BlockPos nearbyPosition : adjacentPositions) {
            if (this.balloonWalls.contains(nearbyPosition) || this.internalAirPositions.contains(nearbyPosition)) continue;
            return false;
        }
        return true;
    }

    private boolean doLastHoleCheck(BlockPos holeToCheck, BlockPos[] adjacentPositions) {
        BalloonHoleDetector holeDetector = new BalloonHoleDetector(holeToCheck, this.parent.field_70170_p, 2500, this);
        if (!holeDetector.cleanHouse) {
            BlockPos fromHash;
            int hash;
            TIntIterator newBallonWallIterator = holeDetector.newBalloonWalls.iterator();
            TIntIterator newAirPostitionsIterator = holeDetector.foundSet.iterator();
            while (newBallonWallIterator.hasNext()) {
                hash = newBallonWallIterator.next();
                fromHash = BalloonHoleDetector.getPosWithRespectTo(hash, holeDetector.firstBlock);
                this.balloonWalls.add(fromHash);
                this.internalAirPositions.remove(fromHash);
                this.balloonHoles.remove(fromHash);
            }
            while (newAirPostitionsIterator.hasNext()) {
                hash = newAirPostitionsIterator.next();
                fromHash = BalloonHoleDetector.getPosWithRespectTo(hash, holeDetector.firstBlock);
                this.internalAirPositions.add(fromHash);
                this.balloonWalls.remove(fromHash);
                this.balloonHoles.remove(fromHash);
            }
            return true;
        }
        return false;
    }

    private BlockPos[] getAdjacentPositions(BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        BlockPos down = pos.func_177977_b();
        BlockPos north = pos.func_177978_c();
        BlockPos east = pos.func_177974_f();
        BlockPos south = pos.func_177968_d();
        BlockPos west = pos.func_177976_e();
        BlockPos[] positions = new BlockPos[]{up, down, north, east, south, west};
        return positions;
    }

    public void updateBalloonCenter() {
        this.currentBalloonCenter.zero();
        this.currentBalloonSize = this.internalAirPositions.size();
        for (BlockPos current : this.internalAirPositions) {
            this.currentBalloonCenter.X += (double)current.func_177958_n();
            this.currentBalloonCenter.Y += (double)current.func_177956_o();
            this.currentBalloonCenter.Z += (double)current.func_177952_p();
        }
        this.currentBalloonCenter.multiply(1.0 / (double)this.currentBalloonSize);
        this.currentBalloonCenter.X += 0.5;
        this.currentBalloonCenter.Y += 0.5;
        this.currentBalloonCenter.Z += 0.5;
    }

    public void updateBalloonRange() {
        Iterator<BlockPos> blockPosIterator = this.balloonWalls.iterator();
        BlockPos firstPos = blockPosIterator.next();
        this.minX = this.maxX = firstPos.func_177958_n();
        this.minY = this.maxY = firstPos.func_177956_o();
        this.minZ = this.maxZ = firstPos.func_177952_p();
        while (blockPosIterator.hasNext()) {
            BlockPos pos = blockPosIterator.next();
            this.minX = Math.min(this.minX, pos.func_177958_n());
            this.minY = Math.min(this.minY, pos.func_177956_o());
            this.minZ = Math.min(this.minZ, pos.func_177952_p());
            this.maxX = Math.max(this.maxX, pos.func_177958_n());
            this.maxY = Math.max(this.maxY, pos.func_177956_o());
            this.maxZ = Math.max(this.maxZ, pos.func_177952_p());
        }
    }

    public boolean isBlockPosInRange(BlockPos toCheck) {
        return toCheck.func_177958_n() >= this.minX && toCheck.func_177958_n() <= this.maxX && toCheck.func_177956_o() >= this.minY && toCheck.func_177956_o() <= this.maxY && toCheck.func_177952_p() >= this.minZ && toCheck.func_177952_p() <= this.maxZ;
    }
}

