/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.balloon;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.addon.control.balloon.BalloonProcessor;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class ShipBalloonManager {
    public ArrayList<BalloonProcessor> balloonProcessors = new ArrayList();
    public ArrayList<BlockPos> recentBlockPositionChanges = new ArrayList();
    public PhysicsObject parent;
    private int curBalloonTick;

    public ShipBalloonManager(PhysicsObject parent) {
        this.parent = parent;
    }

    public BalloonProcessor getProcessorAbovePos(BlockPos burnerPos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos toCheck = burnerPos.func_177981_b(i);
            IBlockState state = this.parent.VKChunkCache.getBlockState(toCheck);
            Block block = state.func_177230_c();
            if (block.field_149764_J.func_76230_c()) {
                i = 420;
                continue;
            }
            for (BalloonProcessor processor : this.balloonProcessors) {
                if (!processor.isBlockPosInRange(toCheck) || !processor.internalAirPositions.contains(toCheck)) continue;
                return processor;
            }
        }
        return null;
    }

    public void addBalloonProcessor(BalloonProcessor toAdd) {
        this.balloonProcessors.add(toAdd);
    }

    public void onPostTick() {
        ++this.curBalloonTick;
        if (this.curBalloonTick > 20) {
            this.curBalloonTick = 0;
            this.processRecentBlockChanges();
        }
    }

    private void processRecentBlockChanges() {
        if (!this.recentBlockPositionChanges.isEmpty()) {
            for (BalloonProcessor processor : this.balloonProcessors) {
                processor.processBlockUpdates(this.recentBlockPositionChanges);
            }
            this.recentBlockPositionChanges.clear();
        }
    }

    public void onBlockPositionRemoved(BlockPos justRemoved) {
        if (!this.recentBlockPositionChanges.contains(justRemoved)) {
            this.recentBlockPositionChanges.add(justRemoved);
        }
    }

    public void onBlockPositionAdded(BlockPos justAdded) {
        if (!this.recentBlockPositionChanges.contains(justAdded)) {
            this.recentBlockPositionChanges.add(justAdded);
        }
    }
}

