/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.balloon.BalloonDetector;
import valkyrienwarfare.addon.control.balloon.BalloonProcessor;
import valkyrienwarfare.addon.control.tileentity.BalloonBurnerTileEntity;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class BlockBalloonBurner
extends Block
implements ITileEntityProvider {
    public BlockBalloonBurner(Material materialIn) {
        super(materialIn);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        PhysicsWrapperEntity wrapperEntity = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(worldIn, pos);
        if (wrapperEntity != null) {
            BlockPos balloonStart = pos.func_177981_b(2);
            if (!worldIn.field_72995_K) {
                BalloonProcessor existingProcessor = wrapperEntity.wrapping.balloonManager.getProcessorAbovePos(pos);
                if (existingProcessor == null) {
                    BalloonDetector detector = new BalloonDetector(balloonStart, worldIn, 25000);
                    int balloonSize = detector.foundSet.size();
                    if (balloonSize == 0) {
                        placer.func_145747_a((ITextComponent)new TextComponentString("No balloon above"));
                    } else {
                        placer.func_145747_a((ITextComponent)new TextComponentString("Created a new balloon"));
                        BalloonProcessor processor = BalloonProcessor.makeProcessorForDetector(wrapperEntity, detector);
                        wrapperEntity.wrapping.balloonManager.addBalloonProcessor(processor);
                    }
                } else {
                    placer.func_145747_a((ITextComponent)new TextComponentString("Hooked onto Exisiting balloon"));
                }
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List itemInformation, boolean par4) {
        itemInformation.add(TextFormatting.ITALIC + "" + TextFormatting.RED + TextFormatting.ITALIC + "Unfinished until v_0.91_alpha");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new BalloonBurnerTileEntity();
    }

    private BalloonBurnerTileEntity getTileEntity(World world, BlockPos pos, IBlockState state, Entity shipEntity) {
        PhysicsWrapperEntity wrapper = (PhysicsWrapperEntity)shipEntity;
        PhysicsObject obj = wrapper.wrapping;
        IBlockState controllerState = obj.VKChunkCache.getBlockState(pos);
        TileEntity worldTile = obj.VKChunkCache.getTileEntity(pos);
        if (worldTile == null) {
            return null;
        }
        if (worldTile instanceof BalloonBurnerTileEntity) {
            BalloonBurnerTileEntity burnerTile = (BalloonBurnerTileEntity)worldTile;
            return burnerTile;
        }
        return null;
    }
}

