/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class BlockShipPassengerChair
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockShipPassengerChair(Material materialIn) {
        super(materialIn);
    }

    public static double getChairYaw(IBlockState state, BlockPos pos) {
        EnumFacing enumFace = (EnumFacing)state.func_177229_b((IProperty)FACING);
        double chairYaw = -enumFace.func_185119_l() - 90.0f;
        return chairYaw;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        PhysicsWrapperEntity wrapper;
        if (!worldIn.field_72995_K && (wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(worldIn, pos)) != null && playerIn.func_184208_bv() != wrapper.func_184208_bv()) {
            Vector playerPos = new Vector((Entity)playerIn);
            wrapper.wrapping.coordTransform.fromLocalToGlobal(playerPos);
            playerIn.field_70165_t = playerPos.X;
            playerIn.field_70163_u = playerPos.Y;
            playerIn.field_70161_v = playerPos.Z;
            playerIn.func_184220_m((Entity)wrapper);
            Vector localMountPos = this.getPlayerMountOffset(state, pos);
            wrapper.wrapping.fixEntity((Entity)playerIn, localMountPos);
            wrapper.wrapping.coordTransform.fromGlobalToLocal(playerPos);
            playerIn.field_70165_t = playerPos.X;
            playerIn.field_70163_u = playerPos.Y;
            playerIn.field_70161_v = playerPos.Z;
            return true;
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List itemInformation, boolean par4) {
        itemInformation.add(TextFormatting.ITALIC + "" + TextFormatting.BLUE + "Use to mount Ships.");
        itemInformation.add(TextFormatting.BOLD + "" + TextFormatting.BOLD + TextFormatting.RED + "Can only be placed on a Ship");
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(worldIn, pos);
        return wrapper != null;
    }

    private Vector getPlayerMountOffset(IBlockState state, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: {
                return new Vector((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.6);
            }
            case SOUTH: {
                return new Vector((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.4);
            }
            case WEST: {
                return new Vector((double)pos.func_177958_n() + 0.6, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            case EAST: {
                return new Vector((double)pos.func_177958_n() + 0.4, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
        }
        return new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(placer.func_70093_af() ? placer.func_174811_aO().func_176734_d() : placer.func_174811_aO()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

