/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import valkyrienwarfare.addon.control.tileentity.ThrustRelayTileEntity;

public class BlockThrustRelay
extends BlockDirectional
implements ITileEntityProvider {
    static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.375, 0.6875, 0.6875);
    static final AxisAlignedBB WEST = new AxisAlignedBB(1.0, 0.3125, 0.3125, 0.625, 0.6875, 0.6875);
    static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.375);
    static final AxisAlignedBB NORTH = new AxisAlignedBB(0.3125, 0.3125, 1.0, 0.6875, 0.6875, 0.625);
    static final AxisAlignedBB UP = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    static final AxisAlignedBB DOWN = new AxisAlignedBB(0.3125, 0.625, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockThrustRelay(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH));
    }

    private static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return worldIn.func_180495_p(blockpos).isSideSolid((IBlockAccess)worldIn, blockpos, direction.func_176734_d());
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        switch (enumfacing) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case NORTH: {
                return NORTH;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return DOWN;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockThrustRelay.canPlaceBlock(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockThrustRelay.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return BlockThrustRelay.canPlaceBlock(worldIn, pos, facing.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.DOWN);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state) && !BlockThrustRelay.canPlaceBlock(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case DOWN: {
                i = 0;
            }
        }
        return i;
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List itemInformation, boolean par4) {
        itemInformation.add(TextFormatting.ITALIC + "" + TextFormatting.RED + TextFormatting.ITALIC + "Unfinished until v_0.91_alpha");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ThrustRelayTileEntity();
    }
}

