/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.controlsystems;

import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.addon.control.nodenetwork.Node;
import valkyrienwarfare.addon.control.tileentity.ThrustModulatorTileEntity;
import valkyrienwarfare.addon.control.tileentity.TileEntityNormalEtherCompressor;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.api.block.ethercompressor.TileEntityEtherCompressor;
import valkyrienwarfare.math.BigBastardMath;
import valkyrienwarfare.physics.PhysicsCalculations;

public class ShipPulseImpulseControlSystem {
    public final ThrustModulatorTileEntity parentTile;
    public double linearVelocityBias = 1.0;
    public double angularVelocityBias = 50.0;
    public double angularConstant = 5.0E8;
    public double linearConstant = 1000000.0;
    private double bobspeed = 10.0;
    private double bobmagnitude = 3.0;
    private double totalSecondsRunning = 0.0;
    private Vector normalVector = new Vector(0.0, 1.0, 0.0);

    public ShipPulseImpulseControlSystem(ThrustModulatorTileEntity parentTile) {
        this.parentTile = parentTile;
        this.totalSecondsRunning = Math.random() * this.bobspeed;
    }

    public void solveThrustValues(PhysicsCalculations calculations) {
        double physTickSpeed = calculations.physTickSpeed;
        double totalThrust = 0.0;
        double totalPotentialThrust = this.getMaxThrustForAllThrusters();
        double currentThrust = this.getTotalThrustForAllThrusters();
        double[] rotationMatrix = calculations.parent.coordTransform.lToWRotation;
        double[] rotationAndTranslationMatrix = calculations.parent.coordTransform.lToWTransform;
        double[] invRotationAndTranslationMatrix = calculations.parent.coordTransform.wToLTransform;
        double[] invMOIMatrix = calculations.invFramedMOI;
        Vector posInWorld = new Vector(calculations.parent.wrapper.field_70165_t, calculations.parent.wrapper.field_70163_u, calculations.parent.wrapper.field_70161_v);
        Vector angularVelocity = new Vector(calculations.angularVelocity);
        Vector linearMomentum = new Vector(calculations.linearMomentum);
        Vector linearVelocity = new Vector(linearMomentum, calculations.invMass);
        BlockPos shipRefrencePos = calculations.parent.refrenceBlockPos;
        double maxYDelta = this.parentTile.maximumYVelocity;
        double idealHeight = this.parentTile.idealYHeight + this.getBobForTime();
        Vector linearMomentumError = this.getIdealMomentumErrorForSystem(calculations, posInWorld, maxYDelta, idealHeight);
        double engineThrustToChange = linearMomentumError.Y;
        double newTotalThrust = currentThrust + engineThrustToChange;
        if (!(newTotalThrust > 0.0) || !(newTotalThrust < totalPotentialThrust)) {
            // empty if block
        }
        double linearThama = 4.5;
        double angularThama = 1343.5;
        Vector theNormal = new Vector(0.0, 1.0, 0.0);
        Vector idealNormal = new Vector(theNormal);
        Vector currentNormal = new Vector(theNormal, calculations.parent.coordTransform.lToWRotation);
        Vector currentNormalError = currentNormal.getSubtraction(idealNormal);
        this.linearVelocityBias = calculations.physTickSpeed;
        for (Node node : this.getNetworkedNodesList()) {
            if (!(node.parentTile instanceof TileEntityEtherCompressor) || ((TileEntityEtherCompressor)node.parentTile).updateParentShip()) continue;
            TileEntityEtherCompressor forceTile = (TileEntityEtherCompressor)node.parentTile;
            Vector angularVelocityAtNormalPosition = angularVelocity.cross(currentNormalError);
            forceTile.updateTicksSinceLastRecievedSignal();
            double currentErrorY = posInWorld.Y - idealHeight + linearThama * (linearMomentum.Y * calculations.invMass);
            double currentEngineErrorAngularY = this.getEngineDistFromIdealAngular(forceTile.func_174877_v(), rotationAndTranslationMatrix, angularVelocity, calculations.centerOfMass, calculations.physTickSpeed);
            Vector potentialMaxForce = new Vector(0.0, forceTile.getMaxThrust(), 0.0);
            potentialMaxForce.multiply(calculations.invMass);
            potentialMaxForce.multiply(calculations.physTickSpeed);
            Vector potentialMaxThrust = forceTile.getPositionInLocalSpaceWithOrientation().cross(potentialMaxForce);
            RotationMatrices.applyTransform3by3(invMOIMatrix, potentialMaxThrust);
            potentialMaxThrust.multiply(calculations.physTickSpeed);
            double futureCurrentErrorY = currentErrorY + linearThama * potentialMaxForce.Y;
            double futureEngineErrorAngularY = this.getEngineDistFromIdealAngular(forceTile.func_174877_v(), rotationAndTranslationMatrix, angularVelocity.getAddition(potentialMaxThrust), calculations.centerOfMass, calculations.physTickSpeed);
            boolean doesForceMinimizeError = false;
            if (Math.abs(futureCurrentErrorY) < Math.abs(currentErrorY) && Math.abs(futureEngineErrorAngularY) < Math.abs(currentEngineErrorAngularY)) {
                doesForceMinimizeError = true;
                if (Math.abs(linearMomentum.Y * calculations.invMass) > maxYDelta) {
                    if (Math.abs((potentialMaxForce.Y + linearMomentum.Y) * calculations.invMass) > Math.abs(linearMomentum.Y * calculations.invMass)) {
                        doesForceMinimizeError = false;
                    }
                } else if (Math.abs((potentialMaxForce.Y + linearMomentum.Y) * calculations.invMass) > maxYDelta) {
                    doesForceMinimizeError = false;
                }
            }
            if (doesForceMinimizeError) {
                forceTile.setThrust(forceTile.getMaxThrust());
                if (Math.abs(currentErrorY) < 1.0) {
                    forceTile.setThrust(forceTile.getMaxThrust() * Math.pow(Math.abs(currentErrorY), 3.0));
                }
            } else {
                forceTile.setThrust(0.0);
            }
            Vector forceOutputWithRespectToTime = forceTile.getForceOutputOriented(calculations.physTickSpeed);
            linearMomentum.add(forceOutputWithRespectToTime);
            Vector torque = forceTile.getPositionInLocalSpaceWithOrientation().cross(forceOutputWithRespectToTime);
            RotationMatrices.applyTransform3by3(invMOIMatrix, torque);
            angularVelocity.add(torque);
        }
        this.totalSecondsRunning += calculations.physTickSpeed;
    }

    private double getBobForTime() {
        double fraction = this.totalSecondsRunning / this.bobspeed;
        double degrees = fraction * 360.0 % 360.0;
        double sinVal = Math.sin(Math.toRadians(degrees));
        return sinVal * this.bobmagnitude;
    }

    public Vector getIdealMomentumErrorForSystem(PhysicsCalculations calculations, Vector posInWorld, double maxYDelta, double idealHeight) {
        double yErrorDistance = idealHeight - posInWorld.Y;
        double idealYLinearMomentumMagnitude = BigBastardMath.limitToRange(yErrorDistance, -maxYDelta, maxYDelta);
        Vector idealLinearMomentum = new Vector(0.0, 1.0, 0.0);
        idealLinearMomentum.multiply(idealYLinearMomentumMagnitude * calculations.mass);
        Vector linearMomentumError = calculations.linearMomentum.getSubtraction(idealLinearMomentum);
        return linearMomentumError;
    }

    public Vector getForceForEngine(TileEntityEtherCompressor engine, BlockPos enginePos, double invMass, Vector linearMomentum, Vector angularVelocity, double[] rotationAndTranslationMatrix, Vector shipPos, Vector centerOfMass, double secondsToApply, double idealHeight) {
        double stabilityVal = 0.145;
        Vector shipVel = new Vector(linearMomentum);
        shipVel.multiply(invMass);
        double linearDist = -this.getControllerDistFromIdealY(rotationAndTranslationMatrix, invMass, shipPos.Y, linearMomentum, idealHeight);
        double angularDist = -this.getEngineDistFromIdealAngular(enginePos, rotationAndTranslationMatrix, angularVelocity, centerOfMass, secondsToApply);
        engine.angularThrust.Y -= this.angularConstant * secondsToApply * angularDist;
        engine.linearThrust.Y -= this.linearConstant * secondsToApply * linearDist;
        engine.angularThrust.Y = Math.max(engine.angularThrust.Y, 0.0);
        engine.linearThrust.Y = Math.max(engine.linearThrust.Y, 0.0);
        engine.angularThrust.Y = Math.min(engine.angularThrust.Y, engine.getMaxThrust() * stabilityVal);
        engine.linearThrust.Y = Math.min(engine.linearThrust.Y, engine.getMaxThrust() * (1.0 - stabilityVal));
        Vector aggregateForce = engine.linearThrust.getAddition(engine.angularThrust);
        aggregateForce.multiply(secondsToApply);
        return aggregateForce;
    }

    public double getEngineDistFromIdealAngular(BlockPos enginePos, double[] lToWRotation, Vector angularVelocity, Vector centerOfMass, double secondsToApply) {
        BlockPos pos = this.parentTile.func_174877_v();
        Vector controllerPos = new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        Vector enginePosVec = new Vector((double)enginePos.func_177958_n() + 0.5, (double)enginePos.func_177956_o() + 0.5, (double)enginePos.func_177952_p() + 0.5);
        controllerPos.subtract(centerOfMass);
        enginePosVec.subtract(centerOfMass);
        Vector unOrientedPosDif = new Vector(enginePosVec.X - controllerPos.X, enginePosVec.Y - controllerPos.Y, enginePosVec.Z - controllerPos.Z);
        double idealYDif = unOrientedPosDif.dot(this.normalVector);
        RotationMatrices.doRotationOnly(lToWRotation, controllerPos);
        RotationMatrices.doRotationOnly(lToWRotation, enginePosVec);
        double inWorldYDif = enginePosVec.Y - controllerPos.Y;
        Vector angularVelocityAtPoint = angularVelocity.cross(enginePosVec);
        angularVelocityAtPoint.multiply(secondsToApply);
        return idealYDif - (inWorldYDif + angularVelocityAtPoint.Y * this.angularVelocityBias);
    }

    public double getControllerDistFromIdealY(double[] lToWTransform, double invMass, double posY, Vector linearMomentum, double idealHeight) {
        BlockPos pos = this.parentTile.func_174877_v();
        Vector controllerPos = new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        controllerPos.transform(lToWTransform);
        return idealHeight - (posY + linearMomentum.Y * invMass * this.linearVelocityBias);
    }

    public double getTotalThrustForAllThrusters() {
        double totalThrust = 0.0;
        for (Node otherNode : this.getNetworkedNodesList()) {
            TileEntity nodeTile = otherNode.parentTile;
            if (!(nodeTile instanceof TileEntityNormalEtherCompressor)) continue;
            TileEntityNormalEtherCompressor ether = (TileEntityNormalEtherCompressor)nodeTile;
            totalThrust += ether.getThrust();
        }
        return totalThrust;
    }

    public double getMaxThrustForAllThrusters() {
        double totalThrustAvaliable = 0.0;
        for (Node otherNode : this.getNetworkedNodesList()) {
            TileEntity nodeTile = otherNode.parentTile;
            if (!(nodeTile instanceof TileEntityNormalEtherCompressor)) continue;
            TileEntityNormalEtherCompressor ether = (TileEntityNormalEtherCompressor)nodeTile;
            totalThrustAvaliable += ether.getMaxThrust();
        }
        return totalThrustAvaliable;
    }

    private HashSet<Node> getNetworkedNodesList() {
        return this.parentTile.tileNode.getNodeNetwork().networkedNodes;
    }
}

