/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.ValkyrienWarfareControl;
import valkyrienwarfare.addon.control.network.HovercraftControllerGUIInputMessage;
import valkyrienwarfare.addon.control.tileentity.TileEntityHoverController;

public class HovercraftControllerGUI
extends GuiContainer {
    private static ResourceLocation background = new ResourceLocation("valkyrienwarfarecontrol", "textures/gui/controlsystemgui.png");
    public TileEntityHoverController tileEnt;
    public ArrayList<GuiTextField> textFields = new ArrayList();

    public HovercraftControllerGUI(EntityPlayer player, TileEntityHoverController entity) {
        super(player.field_71069_bz);
        this.field_146297_k = Minecraft.func_71410_x();
        this.tileEnt = entity;
    }

    public void updateTextFields() {
        this.textFields.get(0).func_146180_a(this.tileEnt.idealHeight + "");
        this.textFields.get(1).func_146180_a(Math.round(this.tileEnt.stabilityBias * 100.0) + "");
        this.textFields.get(2).func_146180_a(this.tileEnt.linearVelocityBias + "");
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean prevFocused = false;
        boolean postFocused = false;
        for (GuiTextField text : this.textFields) {
            prevFocused = text.func_146206_l() || prevFocused;
            text.func_146192_a(mouseX, mouseY, mouseButton);
            postFocused = text.func_146206_l() || postFocused;
        }
        if (prevFocused && !postFocused) {
            this.updateServer();
        }
    }

    public void updateServer() {
        if (this.tileEnt == null) {
            return;
        }
        HovercraftControllerGUIInputMessage toSend = this.getMessage();
        ValkyrienWarfareControl.controlNetwork.sendToServer((IMessage)toSend);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean typed = false;
        for (GuiTextField text : this.textFields) {
            typed = typed || text.func_146201_a(typedChar, keyCode);
        }
        if (!typed) {
            this.updateServer();
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField text : this.textFields) {
            text.func_146178_a();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.textFields.clear();
        int fieldWidth = 40;
        int fieldHeight = 20;
        GuiTextField top = new GuiTextField(0, this.field_146289_q, (this.field_146294_l - fieldWidth) / 2 - 61, (this.field_146295_m - fieldHeight) / 2 - 77, fieldWidth, fieldHeight);
        GuiTextField mid = new GuiTextField(0, this.field_146289_q, (this.field_146294_l - fieldWidth) / 2 - 57, (this.field_146295_m - fieldHeight) / 2 - 49, fieldWidth, fieldHeight);
        GuiTextField bot = new GuiTextField(0, this.field_146289_q, (this.field_146294_l - fieldWidth) / 2 - 57, (this.field_146295_m - fieldHeight) / 2 - 20, fieldWidth, fieldHeight);
        top.func_146185_a(false);
        mid.func_146185_a(false);
        bot.func_146185_a(false);
        this.textFields.add(top);
        this.textFields.add(mid);
        this.textFields.add(bot);
        this.updateTextFields();
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.updateServer();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146976_a(par3, par1, par2);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_146112_a(this.field_146297_k, par1, par2);
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            ((GuiLabel)this.field_146293_o.get(j)).func_146159_a(this.field_146297_k, par1, par2);
        }
        for (GuiTextField text : this.textFields) {
            text.func_146194_f();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int textureWidth = 239;
        int textureHeight = 232;
        this.func_73729_b((this.field_146294_l - textureWidth) / 2, (this.field_146295_m - textureHeight) / 2, 7, 7, textureWidth, textureHeight);
    }

    public void func_146278_c(int tint) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(0.0, (double)this.field_146295_m, 0.0).func_187315_a(0.0, (double)((float)this.field_146295_m / 32.0f + (float)tint)).func_181669_b(64, 64, 64, 255).func_181675_d();
        worldrenderer.func_181662_b((double)this.field_146294_l, (double)this.field_146295_m, 0.0).func_187315_a((double)((float)this.field_146294_l / 32.0f), (double)((float)this.field_146295_m / 32.0f + (float)tint)).func_181669_b(64, 64, 64, 255).func_181675_d();
        worldrenderer.func_181662_b((double)this.field_146294_l, 0.0, 0.0).func_187315_a((double)((float)this.field_146294_l / 32.0f), (double)tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        worldrenderer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, (double)tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    private HovercraftControllerGUIInputMessage getMessage() {
        HovercraftControllerGUIInputMessage toReturn = new HovercraftControllerGUIInputMessage();
        toReturn.tilePos = this.tileEnt.func_174877_v();
        toReturn.physEntId = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)this.field_146297_k.field_71441_e, toReturn.tilePos).func_145782_y();
        try {
            toReturn.newIdealHeight = Double.parseDouble(this.textFields.get(0).func_146179_b());
            toReturn.newStablitiyBias = Double.parseDouble(this.textFields.get(1).func_146179_b()) / 100.0;
            toReturn.newLinearVelocityBias = Double.parseDouble(this.textFields.get(2).func_146179_b());
        }
        catch (Exception e) {
            this.updateTextFields();
        }
        return toReturn;
    }
}

