/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.nodenetwork;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.nodenetwork.BasicNodeTileEntity;
import valkyrienwarfare.addon.control.nodenetwork.IForceTile;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public abstract class BasicForceNodeTileEntity
extends BasicNodeTileEntity
implements IForceTile {
    protected double maxThrust = 5000.0;
    protected double currentThrust = 0.0;
    private Vector forceOutputVector = new Vector();
    private Vector normalVelocityUnoriented;
    private int ticksSinceLastControlSignal = 0;
    private boolean hasAlreadyCheckedForParent = false;

    public BasicForceNodeTileEntity() {
    }

    public BasicForceNodeTileEntity(Vector normalVeclocityUnoriented, boolean isForceOutputOriented, double maxThrust) {
        this.normalVelocityUnoriented = normalVeclocityUnoriented;
        this.maxThrust = maxThrust;
    }

    public boolean isForceOutputOriented() {
        return true;
    }

    @Override
    public Vector getForceOutputNormal() {
        return this.normalVelocityUnoriented;
    }

    @Override
    public Vector getForceOutputUnoriented(double secondsToApply) {
        return this.normalVelocityUnoriented.getProduct(this.currentThrust * secondsToApply);
    }

    @Override
    public Vector getForceOutputOriented(double secondsToApply) {
        Vector outputForce = this.getForceOutputUnoriented(secondsToApply);
        if (this.isForceOutputOriented() && this.updateParentShip()) {
            RotationMatrices.applyTransform(this.tileNode.getPhysicsObject().coordTransform.lToWRotation, outputForce);
        }
        return outputForce;
    }

    @Override
    public double getMaxThrust() {
        return this.maxThrust;
    }

    @Override
    public double getThrust() {
        return this.currentThrust;
    }

    @Override
    public void setThrust(double newMagnitude) {
        this.currentThrust = newMagnitude;
    }

    @Override
    public Vector getPositionInLocalSpaceWithOrientation() {
        if (this.updateParentShip()) {
            return null;
        }
        PhysicsWrapperEntity parentShip = this.tileNode.getPhysicsObject().wrapper;
        Vector engineCenter = new Vector((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        RotationMatrices.applyTransform(parentShip.wrapping.coordTransform.lToWTransform, engineCenter);
        engineCenter.subtract(parentShip.field_70165_t, parentShip.field_70163_u, parentShip.field_70161_v);
        return engineCenter;
    }

    @Override
    public Vector getVelocityAtEngineCenter() {
        if (this.updateParentShip()) {
            return null;
        }
        PhysicsCalculations calculations = this.tileNode.getPhysicsObject().physicsProcessor;
        return calculations.getVelocityAtPoint(this.getPositionInLocalSpaceWithOrientation());
    }

    @Override
    public Vector getLinearVelocityAtEngineCenter() {
        if (this.updateParentShip()) {
            return null;
        }
        PhysicsCalculations calculations = this.tileNode.getPhysicsObject().physicsProcessor;
        return calculations.linearMomentum;
    }

    @Override
    public Vector getAngularVelocityAtEngineCenter() {
        if (this.updateParentShip()) {
            return null;
        }
        PhysicsCalculations calculations = this.tileNode.getPhysicsObject().physicsProcessor;
        return calculations.angularVelocity.cross(this.getPositionInLocalSpaceWithOrientation());
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.maxThrust = compound.func_74769_h("maxThrust");
        this.currentThrust = compound.func_74769_h("currentThrust");
        this.normalVelocityUnoriented = NBTUtils.readVectorFromNBT("normalVelocityUnoriented", compound);
        this.ticksSinceLastControlSignal = compound.func_74762_e("ticksSinceLastControlSignal");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74780_a("maxThrust", this.maxThrust);
        compound.func_74780_a("currentThrust", this.currentThrust);
        NBTUtils.writeVectorToNBT("normalVelocityUnoriented", this.normalVelocityUnoriented, compound);
        compound.func_74768_a("ticksSinceLastControlSignal", this.ticksSinceLastControlSignal);
        return super.func_189515_b(compound);
    }

    public boolean updateParentShip() {
        if (this.hasAlreadyCheckedForParent) {
            return this.tileNode.getPhysicsObject() == null;
        }
        BlockPos pos = this.func_174877_v();
        World world = this.func_145831_w();
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(world, pos);
        this.hasAlreadyCheckedForParent = true;
        if (wrapper != null) {
            this.tileNode.updateParentEntity(wrapper.wrapping);
            return false;
        }
        return true;
    }

    public void updateTicksSinceLastRecievedSignal() {
        this.ticksSinceLastControlSignal = 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.ticksSinceLastControlSignal;
        if (this.ticksSinceLastControlSignal > 5) {
            this.setThrust(this.getThrust() * 0.9);
        }
    }
}

