/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.nodenetwork;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import valkyrienwarfare.addon.control.nodenetwork.INodeProvider;
import valkyrienwarfare.addon.control.nodenetwork.NodeNetwork;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class Node {
    public final TileEntity parentTile;
    public HashSet<Node> connectedNodes;
    public HashSet<BlockPos> connectedNodesBlockPos;
    private PhysicsObject parentPhysicsObject;
    private boolean isRelay;
    private boolean isFullyBuilt = false;
    private NodeNetwork parentNetwork;
    private byte channel = 0;

    public Node(TileEntity parent) {
        this.parentTile = parent;
        this.connectedNodes = new HashSet();
        this.connectedNodesBlockPos = new HashSet();
        this.parentNetwork = new NodeNetwork(this.parentPhysicsObject);
        this.parentNetwork.networkedNodes.add(this);
    }

    public void updateParentEntity(PhysicsObject physObj) {
        this.parentPhysicsObject = physObj;
        this.parentNetwork.setParentPhysicsObject(physObj);
        if (physObj != null) {
            physObj.nodesWithinShip.add(this);
        }
    }

    public void linkNode(Node other) {
        this.updateBuildState();
        this.connectedNodes.add(other);
        other.connectedNodes.add(this);
        this.connectedNodesBlockPos.add(other.parentTile.func_174877_v());
        other.connectedNodesBlockPos.add(this.parentTile.func_174877_v());
        this.parentNetwork.mergeWithNetworks(new NodeNetwork[]{other.parentNetwork});
        if (!this.parentTile.func_145831_w().field_72995_K) {
            this.sendUpdatesToNearby();
            other.sendUpdatesToNearby();
        }
    }

    public void unlinkNode(Node other, boolean updateNodeNetwork, boolean sendToClient) {
        this.updateBuildState();
        this.connectedNodes.remove(other);
        other.connectedNodes.remove(this);
        this.connectedNodesBlockPos.remove(other.parentTile.func_174877_v());
        other.connectedNodesBlockPos.remove(this.parentTile.func_174877_v());
        if (updateNodeNetwork) {
            this.parentNetwork.recalculateNetworks(this);
        }
        if (sendToClient && !this.parentTile.func_145831_w().field_72995_K) {
            this.sendUpdatesToNearby();
            other.sendUpdatesToNearby();
        }
    }

    public void sendUpdatesToNearby() {
        SPacketUpdateTileEntity toSend = this.parentTile.func_189518_D_();
        double xPos = this.parentTile.func_174877_v().func_177958_n();
        double yPos = this.parentTile.func_174877_v().func_177956_o();
        double zPos = this.parentTile.func_174877_v().func_177952_p();
        WorldServer serverWorld = (WorldServer)this.parentTile.func_145831_w();
        PlayerList list = serverWorld.field_73061_a.func_184103_al();
        if (!this.parentTile.func_145837_r()) {
            list.func_148543_a(null, xPos, yPos, zPos, 128.0, serverWorld.field_73011_w.getDimension(), (Packet)toSend);
        }
    }

    public void destroyNode() {
        Object[] backingArray;
        if (this.parentTile.func_145831_w().field_72995_K) {
            this.updateBuildState();
        }
        for (Object node : backingArray = this.connectedNodes.toArray()) {
            this.unlinkNode((Node)node, false, false);
        }
        this.parentNetwork.recalculateNetworks(this);
        if (this.parentPhysicsObject != null) {
            this.parentPhysicsObject.nodesWithinShip.remove(this);
        }
    }

    public PhysicsObject getPhysicsObject() {
        return this.parentPhysicsObject;
    }

    public void updateBuildState() {
        if (!this.isFullyBuilt) {
            this.isFullyBuilt = this.attemptToBuildNodeSet();
            if (!this.isFullyBuilt) {
                System.err.println("Node network building failed");
            }
        }
    }

    public boolean attemptToBuildNodeSet() {
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (BlockPos pos : this.connectedNodesBlockPos) {
            if (!this.parentTile.func_145831_w().func_175667_e(pos)) continue;
            boolean isLoaded = this.parentTile.func_145831_w().func_175667_e(pos);
            TileEntity tile = this.parentTile.func_145831_w().func_175625_s(pos);
            if (tile != null) {
                Node node;
                if (!(tile instanceof INodeProvider) || (node = ((INodeProvider)tile).getNode()) == null) continue;
                this.connectedNodes.add(node);
                node.connectedNodes.add(this);
                this.parentNetwork.mergeWithNetworks(new NodeNetwork[]{node.parentNetwork});
                continue;
            }
            if (!isLoaded) continue;
            toRemove.add(pos);
        }
        this.connectedNodesBlockPos.remove(toRemove);
        return this.connectedNodes.size() == this.connectedNodesBlockPos.size();
    }

    public boolean updateParentNetwork(NodeNetwork newNetwork) {
        if (this.parentNetwork == newNetwork) {
            this.parentNetwork = newNetwork;
            return true;
        }
        this.parentNetwork = newNetwork;
        return false;
    }

    public NodeNetwork getNodeNetwork() {
        return this.parentNetwork;
    }

    public byte getChannel() {
        return this.channel;
    }

    public void setChannel(byte newChannel) {
        this.channel = newChannel;
    }

    public boolean canLinkToNode(Node other) {
        return this.isNodeRelay() || other.isNodeRelay();
    }

    public boolean isNodeRelay() {
        return this.isRelay;
    }

    public void setIsNodeRelay(boolean newVal) {
        this.isRelay = newVal;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.connectedNodesBlockPos.clear();
        int[] connectednodesarray = compound.func_74759_k("connectednodesarray");
        for (int i = 0; i < connectednodesarray.length; i += 3) {
            BlockPos toAdd = new BlockPos(connectednodesarray[i], connectednodesarray[i + 1], connectednodesarray[i + 2]);
            this.connectedNodesBlockPos.add(toAdd);
        }
        this.channel = compound.func_74771_c("channel");
        this.setIsNodeRelay(compound.func_74767_n("isRelay"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        int size = this.connectedNodesBlockPos.size();
        int[] arrayToWrite = new int[size * 3];
        int index = 0;
        for (BlockPos pos : this.connectedNodesBlockPos) {
            arrayToWrite[index] = pos.func_177958_n();
            arrayToWrite[index + 1] = pos.func_177956_o();
            arrayToWrite[index + 2] = pos.func_177952_p();
            index += 3;
        }
        compound.func_74783_a("connectednodesarray", arrayToWrite);
        compound.func_74774_a("channel", this.channel);
        compound.func_74757_a("isRelay", this.isNodeRelay());
        return compound;
    }

    public boolean equals(Object o) {
        Node otherNode;
        return o instanceof Node && ((otherNode = (Node)o) == this || otherNode.parentTile == this.parentTile || otherNode.parentTile.func_174877_v().equals((Object)this.parentTile.func_174877_v()));
    }
}

