/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.nodenetwork;

import java.util.ArrayList;
import java.util.HashSet;
import valkyrienwarfare.addon.control.nodenetwork.Node;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class NodeNetwork {
    public final HashSet<Node> networkedNodes;
    private PhysicsObject parentEntity;

    public NodeNetwork(PhysicsObject parentEntity) {
        this.networkedNodes = new HashSet();
        this.parentEntity = parentEntity;
    }

    public NodeNetwork(HashSet<Node> backingSet, PhysicsObject parentEntity) {
        this.networkedNodes = backingSet;
        this.parentEntity = parentEntity;
    }

    public NodeNetwork(Node parent, PhysicsObject parentEntity) {
        this(parentEntity);
        this.networkedNodes.add(parent);
    }

    private static void fillWithConnections(Node start, HashSet<Node> toFill) {
        toFill.add(start);
        for (Node otherNodes : start.connectedNodes) {
            if (toFill.contains(otherNodes)) continue;
            NodeNetwork.fillWithConnections(otherNodes, toFill);
        }
    }

    public void recalculateNetworks(Node node) {
        this.networkedNodes.remove(node);
        ArrayList<Node> networkedNodesCopy = new ArrayList<Node>(this.networkedNodes);
        this.networkedNodes.clear();
        ArrayList<HashSet<Node>> listOfHashSetsOfNodes = new ArrayList<HashSet<Node>>();
        while (!networkedNodesCopy.isEmpty()) {
            Node startPoint = networkedNodesCopy.get(0);
            HashSet<Node> hashSet = new HashSet<Node>();
            NodeNetwork.fillWithConnections(startPoint, hashSet);
            listOfHashSetsOfNodes.add(hashSet);
            networkedNodesCopy.removeAll(hashSet);
        }
        for (HashSet hashSet : listOfHashSetsOfNodes) {
            NodeNetwork network = new NodeNetwork(hashSet, this.parentEntity);
            for (Node nodeToUpdate : hashSet) {
                nodeToUpdate.updateParentNetwork(network);
            }
        }
    }

    public void mergeWithNetworks(NodeNetwork[] networks) {
        int totalSize = networks.length;
        for (int i = 0; i < totalSize; ++i) {
            this.networkedNodes.addAll(networks[i].networkedNodes);
        }
        for (Node node : this.networkedNodes) {
            node.updateParentNetwork(this);
        }
    }

    public PhysicsObject getParentPhysicsObject() {
        return this.parentEntity;
    }

    public void setParentPhysicsObject(PhysicsObject physObj) {
        this.parentEntity = physObj;
    }
}

