/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.ValkyrienWarfareControl;
import valkyrienwarfare.addon.control.network.MessageStartPiloting;
import valkyrienwarfare.addon.control.network.MessageStopPiloting;
import valkyrienwarfare.addon.control.nodenetwork.BasicNodeTileEntity;
import valkyrienwarfare.addon.control.piloting.ControllerInputType;
import valkyrienwarfare.addon.control.piloting.ITileEntityPilotable;
import valkyrienwarfare.addon.control.piloting.PilotControlsMessage;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public abstract class ImplTileEntityPilotable
extends BasicNodeTileEntity
implements ITileEntityPilotable {
    private EntityPlayer pilotPlayerEntity;

    @Override
    public final void onPilotControlsMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        if (sender == this.pilotPlayerEntity) {
            this.processControlMessage(message, sender);
        }
    }

    @Override
    public final EntityPlayer getPilotEntity() {
        return this.pilotPlayerEntity;
    }

    @Override
    public final void setPilotEntity(EntityPlayer toSet) {
        if (!this.func_145831_w().field_72995_K) {
            this.sendPilotUpdatePackets((EntityPlayerMP)toSet, (EntityPlayerMP)this.pilotPlayerEntity);
        }
        this.pilotPlayerEntity = toSet;
        if (this.pilotPlayerEntity != null) {
            this.onStartTileUsage(this.pilotPlayerEntity);
        } else {
            this.onStopTileUsage();
        }
    }

    @Override
    public final void playerWantsToStopPiloting(EntityPlayer player) {
        if (player == this.getPilotEntity()) {
            this.setPilotEntity(null);
        }
    }

    @Override
    public final PhysicsWrapperEntity getParentPhysicsEntity() {
        return ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.func_145831_w(), this.func_174877_v());
    }

    private final void sendPilotUpdatePackets(EntityPlayerMP newPilot, EntityPlayerMP oldPilot) {
        MessageStopPiloting stopMessage = new MessageStopPiloting(this.func_174877_v());
        MessageStartPiloting startMessage = new MessageStartPiloting(this.func_174877_v(), this.setClientPilotingEntireShip(), this.getControlInputType());
        if (oldPilot != null) {
            ValkyrienWarfareControl.controlNetwork.sendTo((IMessage)stopMessage, oldPilot);
        }
        if (newPilot != null) {
            ValkyrienWarfareControl.controlNetwork.sendTo((IMessage)startMessage, newPilot);
        }
    }

    abstract ControllerInputType getControlInputType();

    abstract boolean setClientPilotingEntireShip();

    abstract void processControlMessage(PilotControlsMessage var1, EntityPlayerMP var2);

    final void sendUpdatePacketToAllNearby() {
        SPacketUpdateTileEntity spacketupdatetileentity = this.func_189518_D_();
        WorldServer serverWorld = (WorldServer)this.field_145850_b;
        Vector pos = new Vector(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.func_145831_w(), this.func_174877_v());
        if (wrapper != null) {
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, pos);
        }
        serverWorld.field_73061_a.func_184103_al().func_148543_a(null, pos.X, pos.Y, pos.Z, 128.0, this.func_145831_w().field_73011_w.getDimension(), (Packet)spacketupdatetileentity);
    }
}

