/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import valkyrienwarfare.addon.control.controlsystems.ShipPulseImpulseControlSystem;
import valkyrienwarfare.addon.control.network.ThrustModulatorGuiInputMessage;
import valkyrienwarfare.addon.control.nodenetwork.Node;
import valkyrienwarfare.addon.control.proxy.ClientProxyControl;
import valkyrienwarfare.addon.control.tileentity.ImplPhysicsProcessorNodeTileEntity;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class ThrustModulatorTileEntity
extends ImplPhysicsProcessorNodeTileEntity {
    public ShipPulseImpulseControlSystem controlSystem = new ShipPulseImpulseControlSystem(this);
    public double idealYHeight = 25.0;
    public double maximumYVelocity = 10.0;

    @Override
    public void onPhysicsTick(PhysicsObject object, PhysicsCalculations calculations, double secondsToSimulate) {
        this.controlSystem.solveThrustValues(calculations);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        ClientProxyControl.checkForTextFieldUpdate(this);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.idealYHeight = compound.func_74760_g("idealYHeight");
        this.maximumYVelocity = compound.func_74760_g("maximumYVelocity");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74776_a("idealYHeight", (float)this.idealYHeight);
        compound.func_74776_a("maximumYVelocity", (float)this.maximumYVelocity);
        return compound;
    }

    public void handleGUIInput(ThrustModulatorGuiInputMessage message, MessageContext ctx) {
        this.idealYHeight = Math.min((double)message.idealYHeight, 5000.0);
        this.maximumYVelocity = Math.max(Math.min((double)message.maximumYVelocity, 100.0), 0.0);
        Node thisTileEntitiesNode = this.getNode();
        thisTileEntitiesNode.sendUpdatesToNearby();
        this.func_70296_d();
    }
}

