/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.tileentity;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.addon.control.network.HovercraftControllerGUIInputMessage;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.api.block.ethercompressor.TileEntityEtherCompressor;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

@Deprecated
public class TileEntityHoverController
extends TileEntity {
    public ArrayList<BlockPos> enginePositions = new ArrayList();
    public double idealHeight = 16.0;
    public double stabilityBias = 0.45;
    public double linearVelocityBias = 1.0;
    public double angularVelocityBias = 50.0;
    public Vector normalVector = new Vector(0.0, 1.0, 0.0);
    public double angularConstant = 5.0E8;
    public double linearConstant = 1000000.0;
    public boolean autoStabalizerControl = false;

    public Vector getForceForEngine(TileEntityEtherCompressor engine, World world, BlockPos enginePos, IBlockState state, PhysicsObject physObj, double secondsToApply) {
        Vector shipVel = new Vector(physObj.physicsProcessor.linearMomentum);
        shipVel.multiply(physObj.physicsProcessor.invMass);
        if (!world.func_175640_z(this.func_174877_v()) || this.autoStabalizerControl) {
            // empty if block
        }
        PhysicsCalculations calculations = physObj.physicsProcessor;
        double[] rotationAndTranslationMatrix = physObj.coordTransform.lToWTransform;
        Vector angularVelocity = new Vector(calculations.angularVelocity);
        Vector linearMomentum = new Vector(calculations.linearMomentum);
        double currentErrorY = -this.getControllerDistFromIdealY(physObj);
        double currentEngineErrorAngularY = -this.getEngineDistFromIdealAngular(enginePos, physObj, secondsToApply);
        Vector potentialMaxForce = new Vector(0.0, engine.getMaxThrust(), 0.0);
        potentialMaxForce.multiply(calculations.invMass);
        potentialMaxForce.multiply(calculations.physTickSpeed);
        Vector potentialMaxThrust = engine.getPositionInLocalSpaceWithOrientation().cross(potentialMaxForce);
        RotationMatrices.applyTransform3by3(calculations.invFramedMOI, potentialMaxThrust);
        potentialMaxThrust.multiply(calculations.physTickSpeed);
        double linearThama = 4.5;
        double maxYDelta = 10.0;
        double futureCurrentErrorY = currentErrorY + linearThama * potentialMaxForce.Y;
        double futureEngineErrorAngularY = this.getEngineDistFromIdealAngular(engine.func_174877_v(), rotationAndTranslationMatrix, angularVelocity.getAddition(potentialMaxThrust), calculations.centerOfMass, calculations.physTickSpeed);
        boolean doesForceMinimizeError = false;
        if (Math.abs(futureCurrentErrorY) < Math.abs(currentErrorY) && Math.abs(futureEngineErrorAngularY) < Math.abs(currentEngineErrorAngularY)) {
            doesForceMinimizeError = true;
            if (Math.abs(linearMomentum.Y * calculations.invMass) > maxYDelta) {
                if (Math.abs((potentialMaxForce.Y + linearMomentum.Y) * calculations.invMass) > Math.abs(linearMomentum.Y * calculations.invMass)) {
                    doesForceMinimizeError = false;
                }
            } else if (Math.abs((potentialMaxForce.Y + linearMomentum.Y) * calculations.invMass) > maxYDelta) {
                doesForceMinimizeError = false;
            }
        }
        if (doesForceMinimizeError) {
            engine.setThrust(engine.getMaxThrust());
            if (Math.abs(currentErrorY) < 1.0) {
                engine.setThrust(engine.getMaxThrust() * Math.pow(Math.abs(currentErrorY), 3.0));
            }
        } else {
            engine.setThrust(0.0);
        }
        return engine.getForceOutputNormal().getProduct(engine.getThrust() * secondsToApply);
    }

    public double getEngineDistFromIdealAngular(BlockPos enginePos, PhysicsObject physObj, double secondsToApply) {
        Vector controllerPos = new Vector((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        Vector enginePosVec = new Vector((double)enginePos.func_177958_n() + 0.5, (double)enginePos.func_177956_o() + 0.5, (double)enginePos.func_177952_p() + 0.5);
        controllerPos.subtract(physObj.physicsProcessor.centerOfMass);
        enginePosVec.subtract(physObj.physicsProcessor.centerOfMass);
        Vector unOrientedPosDif = new Vector(enginePosVec.X - controllerPos.X, enginePosVec.Y - controllerPos.Y, enginePosVec.Z - controllerPos.Z);
        double idealYDif = unOrientedPosDif.dot(this.normalVector);
        RotationMatrices.doRotationOnly(physObj.coordTransform.lToWRotation, controllerPos);
        RotationMatrices.doRotationOnly(physObj.coordTransform.lToWRotation, enginePosVec);
        double inWorldYDif = enginePosVec.Y - controllerPos.Y;
        Vector angularVelocityAtPoint = physObj.physicsProcessor.angularVelocity.cross(enginePosVec);
        angularVelocityAtPoint.multiply(secondsToApply);
        return idealYDif - (inWorldYDif + angularVelocityAtPoint.Y * this.angularVelocityBias);
    }

    public double getEngineDistFromIdealAngular(BlockPos enginePos, double[] lToWRotation, Vector angularVelocity, Vector centerOfMass, double secondsToApply) {
        Vector controllerPos = new Vector((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        Vector enginePosVec = new Vector((double)enginePos.func_177958_n() + 0.5, (double)enginePos.func_177956_o() + 0.5, (double)enginePos.func_177952_p() + 0.5);
        controllerPos.subtract(centerOfMass);
        enginePosVec.subtract(centerOfMass);
        Vector unOrientedPosDif = new Vector(enginePosVec.X - controllerPos.X, enginePosVec.Y - controllerPos.Y, enginePosVec.Z - controllerPos.Z);
        double idealYDif = unOrientedPosDif.dot(this.normalVector);
        RotationMatrices.doRotationOnly(lToWRotation, controllerPos);
        RotationMatrices.doRotationOnly(lToWRotation, enginePosVec);
        double inWorldYDif = enginePosVec.Y - controllerPos.Y;
        Vector angularVelocityAtPoint = angularVelocity.cross(enginePosVec);
        angularVelocityAtPoint.multiply(secondsToApply);
        return idealYDif - (inWorldYDif + angularVelocityAtPoint.Y * this.angularVelocityBias);
    }

    public double getControllerDistFromIdealY(PhysicsObject physObj) {
        Vector controllerPos = new Vector((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        physObj.coordTransform.fromLocalToGlobal(controllerPos);
        return this.idealHeight - (physObj.physicsProcessor.wrapperEnt.field_70163_u + physObj.physicsProcessor.linearMomentum.Y * physObj.physicsProcessor.invMass * this.linearVelocityBias * 3.0);
    }

    public void handleGUIInput(HovercraftControllerGUIInputMessage message, MessageContext ctx) {
        this.idealHeight = message.newIdealHeight;
        if (!(message.newStablitiyBias < 0.0) && !(message.newStablitiyBias > 1.0)) {
            double stabilityDif = Math.abs(this.stabilityBias - message.newStablitiyBias);
            this.stabilityBias = message.newStablitiyBias;
        }
        this.linearVelocityBias = message.newLinearVelocityBias;
        this.func_70296_d();
    }

    private void setAutoStabilizationValue(PhysicsObject physObj) {
        Vector controllerPos = new Vector((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        physObj.coordTransform.fromLocalToGlobal(controllerPos);
        double controllerDistToIdeal = -(this.idealHeight - physObj.physicsProcessor.wrapperEnt.field_70163_u);
        double yVelocity = physObj.physicsProcessor.linearMomentum.Y * physObj.physicsProcessor.invMass * this.linearVelocityBias;
        double biasChange = 5.0E-5;
        if (Math.abs(controllerDistToIdeal + yVelocity) > 0.5) {
            if (yVelocity > 0.0 && controllerDistToIdeal > 0.0 || yVelocity < 0.0 && controllerDistToIdeal < 0.0) {
                double modifiyer = 10.5;
                if (Math.abs(controllerDistToIdeal + yVelocity) < 40.0) {
                    if (Math.abs(controllerDistToIdeal) > 0.5) {
                        this.stabilityBias *= 0.9999;
                    }
                } else {
                    this.stabilityBias -= biasChange * Math.max(Math.log10(Math.abs(controllerDistToIdeal + yVelocity)), 0.0) * modifiyer;
                }
            }
        } else {
            this.stabilityBias += biasChange * 0.5 / Math.pow(Math.min(0.5, Math.abs(controllerDistToIdeal + yVelocity)), 0.5) / 10.0;
        }
        this.stabilityBias = Math.max(Math.min(this.stabilityBias, 1.0), 0.01);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.enginePositions = NBTUtils.readBlockPosArrayListFromNBT("enginePositions", compound);
        this.normalVector = NBTUtils.readVectorFromNBT("normalVector", compound);
        if (this.normalVector.isZero()) {
            this.normalVector = new Vector(0.0, 1.0, 0.0);
        }
        this.idealHeight = compound.func_74769_h("idealHeight");
        this.stabilityBias = compound.func_74769_h("stabilityBias");
        this.linearVelocityBias = compound.func_74769_h("linearVelocityBias");
        this.angularVelocityBias = compound.func_74769_h("angularVelocityBias");
        this.autoStabalizerControl = compound.func_74767_n("autoStabalizerControl");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTUtils.writeBlockPosArrayListToNBT("enginePositions", this.enginePositions, compound);
        NBTUtils.writeVectorToNBT("normalVector", this.normalVector, compound);
        compound.func_74780_a("idealHeight", this.idealHeight);
        compound.func_74780_a("stabilityBias", this.stabilityBias);
        compound.func_74780_a("linearVelocityBias", this.linearVelocityBias);
        compound.func_74780_a("angularVelocityBias", this.angularVelocityBias);
        compound.func_74757_a("autoStabalizerControl", this.autoStabalizerControl);
        return super.func_189515_b(compound);
    }
}

