/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.addon.control.ValkyrienWarfareControl;
import valkyrienwarfare.addon.control.block.BlockShipPilotsChair;
import valkyrienwarfare.addon.control.piloting.ControllerInputType;
import valkyrienwarfare.addon.control.piloting.PilotControlsMessage;
import valkyrienwarfare.addon.control.tileentity.ImplTileEntityPilotable;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class TileEntityPilotsChair
extends ImplTileEntityPilotable {
    @Override
    void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == ValkyrienWarfareControl.INSTANCE.pilotsChair) {
            PhysicsWrapperEntity wrapper = this.getParentPhysicsEntity();
            if (wrapper != null) {
                this.processCalculationsForControlMessageAndApplyCalculations(wrapper, message, blockState);
            }
        } else {
            this.setPilotEntity(null);
        }
    }

    @Override
    final ControllerInputType getControlInputType() {
        return ControllerInputType.PilotsChair;
    }

    @Override
    final boolean setClientPilotingEntireShip() {
        return true;
    }

    @Override
    public final void onStartTileUsage(EntityPlayer player) {
        this.getParentPhysicsEntity().wrapping.physicsProcessor.actAsArchimedes = true;
    }

    @Override
    public final void onStopTileUsage() {
        this.getParentPhysicsEntity().wrapping.physicsProcessor.actAsArchimedes = false;
    }

    private final void processCalculationsForControlMessageAndApplyCalculations(PhysicsWrapperEntity wrapper, PilotControlsMessage message, IBlockState state) {
        BlockPos chairPosition = this.func_174877_v();
        PhysicsObject controlledShip = wrapper.wrapping;
        double pilotPitch = 0.0;
        BlockShipPilotsChair cfr_ignored_0 = (BlockShipPilotsChair)state.func_177230_c();
        double pilotYaw = BlockShipPilotsChair.getChairYaw(state, chairPosition);
        double pilotRoll = 0.0;
        double[] pilotRotationMatrix = RotationMatrices.getRotationMatrix(pilotPitch, pilotYaw, pilotRoll);
        Vector playerDirection = new Vector(1.0, 0.0, 0.0);
        Vector rightDirection = new Vector(0.0, 0.0, 1.0);
        Vector leftDirection = new Vector(0.0, 0.0, -1.0);
        RotationMatrices.applyTransform(pilotRotationMatrix, playerDirection);
        RotationMatrices.applyTransform(pilotRotationMatrix, rightDirection);
        RotationMatrices.applyTransform(pilotRotationMatrix, leftDirection);
        Vector upDirection = new Vector(0.0, 1.0, 0.0);
        Vector downDirection = new Vector(0.0, -1.0, 0.0);
        Vector idealAngularDirection = new Vector();
        Vector idealLinearVelocity = new Vector();
        Vector shipUp = new Vector(0.0, 1.0, 0.0);
        Vector shipUpPos = new Vector(0.0, 1.0, 0.0);
        if (message.airshipForward_KeyDown) {
            idealLinearVelocity.add(playerDirection);
        }
        if (message.airshipBackward_KeyDown) {
            idealLinearVelocity.subtract(playerDirection);
        }
        RotationMatrices.applyTransform(controlledShip.coordTransform.lToWRotation, idealLinearVelocity);
        RotationMatrices.applyTransform(controlledShip.coordTransform.lToWRotation, shipUp);
        if (message.airshipUp_KeyDown) {
            idealLinearVelocity.add(upDirection);
        }
        if (message.airshipDown_KeyDown) {
            idealLinearVelocity.add(downDirection);
        }
        if (message.airshipRight_KeyDown) {
            idealAngularDirection.add(rightDirection);
        }
        if (message.airshipLeft_KeyDown) {
            idealAngularDirection.add(leftDirection);
        }
        Vector shipUpOffset = shipUp.getSubtraction(shipUpPos);
        double mass = controlledShip.physicsProcessor.mass;
        idealLinearVelocity.multiply(mass / 5.0);
        idealAngularDirection.multiply(0.16666666666666666);
        shipUpOffset.multiply(0.3333333333333333);
        Vector velocityCompenstationLinear = controlledShip.physicsProcessor.linearMomentum;
        Vector velocityCompensationAngular = controlledShip.physicsProcessor.angularVelocity.cross(playerDirection);
        Vector velocityCompensationAlignment = controlledShip.physicsProcessor.angularVelocity.cross(shipUpPos);
        velocityCompensationAlignment.multiply(controlledShip.physicsProcessor.physRawSpeed);
        velocityCompensationAngular.multiply(2.0 * controlledShip.physicsProcessor.physRawSpeed);
        shipUpOffset.subtract(velocityCompensationAlignment);
        velocityCompensationAngular.subtract(velocityCompensationAngular);
        RotationMatrices.applyTransform3by3(controlledShip.physicsProcessor.framedMOI, idealAngularDirection);
        RotationMatrices.applyTransform3by3(controlledShip.physicsProcessor.framedMOI, shipUpOffset);
        if (message.airshipSprinting) {
            idealLinearVelocity.multiply(2.0);
        }
        idealLinearVelocity.subtract(idealAngularDirection);
        idealLinearVelocity.subtract(shipUpOffset);
        controlledShip.physicsProcessor.addForceAtPoint(playerDirection, idealAngularDirection);
        controlledShip.physicsProcessor.addForceAtPoint(shipUpPos, shipUpOffset);
        controlledShip.physicsProcessor.addForceAtPoint(new Vector(), idealLinearVelocity);
        controlledShip.physicsProcessor.convertTorqueToVelocity();
    }
}

