/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.control.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.block.BlockShipHelm;
import valkyrienwarfare.addon.control.piloting.ControllerInputType;
import valkyrienwarfare.addon.control.piloting.PilotControlsMessage;
import valkyrienwarfare.addon.control.tileentity.ImplTileEntityPilotable;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class TileEntityShipHelm
extends ImplTileEntityPilotable
implements ITickable {
    public double compassAngle = 0.0;
    public double lastCompassAngle = 0.0;
    public double wheelRotation = 0.0;
    public double lastWheelRotation = 0.0;
    double nextWheelRotation;

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.calculateCompassAngle();
            this.lastWheelRotation = this.wheelRotation;
            this.wheelRotation = this.nextWheelRotation;
        } else {
            double toOriginRate = 5.0;
            this.wheelRotation = Math.abs(this.wheelRotation) < toOriginRate ? 0.0 : (this.wheelRotation += -Math.signum(this.wheelRotation) * toOriginRate);
            this.sendUpdatePacketToAllNearby();
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.nextWheelRotation = pkt.func_148857_g().func_74769_h("wheelRotation");
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagToSend = new NBTTagCompound();
        tagToSend.func_74780_a("wheelRotation", this.wheelRotation);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tagToSend);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound toReturn = super.func_189517_E_();
        toReturn.func_74780_a("wheelRotation", this.wheelRotation);
        return toReturn;
    }

    public void calculateCompassAngle() {
        this.lastCompassAngle = this.compassAngle;
        IBlockState helmState = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing enumfacing = (EnumFacing)helmState.func_177229_b((IProperty)BlockShipHelm.FACING);
        double wheelAndCompassStateRotation = enumfacing.func_185119_l();
        BlockPos spawnPos = this.func_145831_w().func_175694_M();
        Vector compassPoint = new Vector(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        compassPoint.add(1.0, 2.0, 1.0);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.func_145831_w(), this.func_174877_v());
        if (wrapper != null) {
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, compassPoint);
        }
        Vector compassDirection = new Vector(compassPoint);
        compassDirection.subtract(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        if (wrapper != null) {
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.wToLRotation, compassDirection);
        }
        compassDirection.normalize();
        this.compassAngle = Math.toDegrees(Math.atan2(compassDirection.X, compassDirection.Z)) - wheelAndCompassStateRotation;
        this.compassAngle = (this.compassAngle + 360.0) % 360.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.lastWheelRotation = this.wheelRotation = compound.func_74769_h("wheelRotation");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        compound.func_74780_a("wheelRotation", this.wheelRotation);
        return toReturn;
    }

    @Override
    ControllerInputType getControlInputType() {
        return ControllerInputType.ShipHelm;
    }

    @Override
    boolean setClientPilotingEntireShip() {
        return false;
    }

    @Override
    void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        if (message.airshipLeft_KeyDown) {
            this.wheelRotation -= 10.0;
        }
        if (message.airshipRight_KeyDown) {
            this.wheelRotation += 10.0;
        }
    }
}

