/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.world.tileentity;

import javax.vecmath.Vector2d;
import net.minecraft.nbt.NBTTagCompound;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.tileentity.ImplPhysicsProcessorNodeTileEntity;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physics.PhysicsCalculationsManualControl;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.ShipType;

public class TileEntitySkyTempleController
extends ImplPhysicsProcessorNodeTileEntity {
    double yawChangeRate = 8.0;
    double yawPathRate = 2.0;
    double yPathRate = 2.0;
    double totalSecondsExisted = Math.random() * 15.0;
    private Vector originPos = new Vector();
    private double orbitDistance;

    @Override
    public void onPhysicsTick(PhysicsObject object, PhysicsCalculations calculations, double secondsToSimulate) {
        if (calculations instanceof PhysicsCalculationsManualControl) {
            PhysicsCalculationsManualControl manualControl = (PhysicsCalculationsManualControl)calculations;
            ((PhysicsCalculationsManualControl)calculations).useLinearMomentumForce = true;
            if (this.originPos == null || this.originPos.isZero()) {
                this.setOriginPos(new Vector(object.wrapper.field_70165_t, object.wrapper.field_70163_u, object.wrapper.field_70161_v));
            }
            manualControl.yawRate = this.yawChangeRate;
            Vector2d distanceFromCenter = new Vector2d(object.wrapper.field_70165_t - this.originPos.X, object.wrapper.field_70161_v - this.originPos.Z);
            double realDist = distanceFromCenter.length();
            double invTan = Math.toDegrees(Math.atan2(distanceFromCenter.getY(), distanceFromCenter.getX()));
            double velocityAngle = invTan + 90.0;
            double x = Math.cos(Math.toRadians(velocityAngle)) * this.yawPathRate;
            double z = Math.sin(Math.toRadians(velocityAngle)) * this.yawPathRate;
            if (realDist / this.orbitDistance > 1.0) {
                double reductionFactor = realDist / realDist - 1.0;
                x -= reductionFactor * distanceFromCenter.x * this.yawPathRate;
                z -= reductionFactor * distanceFromCenter.y * this.yawPathRate;
            }
            calculations.linearMomentum.X = x * calculations.mass;
            calculations.linearMomentum.Z = z * calculations.mass;
            this.totalSecondsExisted += secondsToSimulate;
            calculations.linearMomentum.Y = Math.sin(Math.toRadians(this.totalSecondsExisted * 7.5)) * this.yPathRate;
        }
    }

    @Override
    public void func_145843_s() {
        PhysicsWrapperEntity wrapper;
        super.func_145843_s();
        if (!this.func_145831_w().field_72995_K && (wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.func_145831_w(), this.func_174877_v())) != null && wrapper.wrapping.physicsProcessor instanceof PhysicsCalculationsManualControl) {
            wrapper.wrapping.physicsProcessor = ((PhysicsCalculationsManualControl)wrapper.wrapping.physicsProcessor).downgradeToNormalCalculations();
            wrapper.wrapping.shipType = ShipType.Full_Unlocked;
        }
    }

    public void setOriginPos(Vector newPos) {
        this.originPos = newPos;
        double orbitDistance = 40.0 + Math.random() * 60.0;
        this.originPos.X -= orbitDistance;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.originPos = NBTUtils.readVectorFromNBT("originPos", compound);
        this.orbitDistance = compound.func_74769_h("orbitDistance");
        this.yawChangeRate = compound.func_74769_h("yawChangeRate");
        this.yawPathRate = compound.func_74769_h("yawPathRate");
        this.yPathRate = compound.func_74769_h("yPathRate");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTUtils.writeVectorToNBT("originPos", this.originPos, compound);
        compound.func_74780_a("orbitDistance", this.orbitDistance);
        compound.func_74780_a("yawChangeRate", this.yawChangeRate);
        compound.func_74780_a("yawPathRate", this.yawPathRate);
        compound.func_74780_a("yPathRate", this.yPathRate);
        return compound;
    }
}

