/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.addon.world.worldgen;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import valkyrienwarfare.addon.world.ValkyrienWarfareWorld;
import valkyrienwarfare.addon.world.worldgen.mobiledungeons.SkyTempleGenerator;
import valkyrienwarfare.chunkmanagement.PhysicsChunkManager;

public class ValkyrienWarfareWorldGen
implements IWorldGenerator {
    public WorldGenMinable genEtheriumOre;

    public ValkyrienWarfareWorldGen() {
        this.genEtheriumOre = new WorldGenMinable(ValkyrienWarfareWorld.INSTANCE.etheriumOre.func_176223_P(), 8);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.runEtheriumGenerator((WorldGenerator)this.genEtheriumOre, world, random, chunkX, chunkZ, 2, 0, 25);
                break;
            }
            case -1: {
                break;
            }
        }
    }

    private void runEtheriumGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    private void runDungeonGenerator(World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn) {
        boolean isLikelyShipChunk = PhysicsChunkManager.isLikelyShipChunk(chunk_X, chunk_Z);
        if (!isLikelyShipChunk && Minecraft.func_71410_x().field_71439_g != null) {
            double random = Math.random();
            SkyTempleGenerator.runGenerator(world, chunk_X, chunk_Z, random);
        }
    }
}

