/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.api;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.ValkyrienWarfareHooks;
import valkyrienwarfare.api.Vector;

public interface IBlockForceProvider {
    default public Vector getBlockForceInWorldSpace(World world, BlockPos pos, IBlockState state, Entity shipEntity, double secondsToApply) {
        Vector toReturn = this.getBlockForceInShipSpace(world, pos, state, shipEntity, secondsToApply);
        if (toReturn == null || shipEntity == null) {
            return null;
        }
        if (this.shouldLocalForceBeRotated(world, pos, state, secondsToApply)) {
            double[] tranformationMatrix = ValkyrienWarfareHooks.getShipTransformMatrix(shipEntity);
            RotationMatrices.doRotationOnly(tranformationMatrix, toReturn);
        }
        return toReturn;
    }

    public Vector getBlockForceInShipSpace(World var1, BlockPos var2, IBlockState var3, Entity var4, double var5);

    default public boolean shouldLocalForceBeRotated(World world, BlockPos pos, IBlockState state, double secondsToApply) {
        return true;
    }

    default public Vector getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, Entity shipEntity, double secondsToApply) {
        return null;
    }
}

