/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.math.BigBastardMath;

public class RotationMatrices {
    public static final float[] transpose(float[] matrix) {
        float[] transpose = new float[]{matrix[0], matrix[4], matrix[8], matrix[12], matrix[1], matrix[5], matrix[9], matrix[13], matrix[2], matrix[6], matrix[10], matrix[14], matrix[3], matrix[7], matrix[11], matrix[15]};
        return transpose;
    }

    public static final double[] getTranslationMatrix(double x, double y, double z) {
        double[] matrix = RotationMatrices.getDoubleIdentity();
        matrix[3] = x;
        matrix[7] = y;
        matrix[11] = z;
        return matrix;
    }

    public static final double[] rotateAndTranslate(double[] input, double pitch, double yaw, double roll, Vector localOrigin) {
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(1.0, 0.0, 0.0, Math.toRadians(pitch)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 1.0, 0.0, Math.toRadians(yaw)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 0.0, 1.0, Math.toRadians(roll)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getTranslationMatrix(-localOrigin.X, -localOrigin.Y, -localOrigin.Z));
        return input;
    }

    public static final double[] rotateOnly(double[] input, double pitch, double yaw, double roll) {
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(1.0, 0.0, 0.0, Math.toRadians(pitch)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 1.0, 0.0, Math.toRadians(yaw)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 0.0, 1.0, Math.toRadians(roll)));
        return input;
    }

    public static final double[] getRotationMatrix(double pitch, double yaw, double roll) {
        double[] input = RotationMatrices.getRotationMatrix(1.0, 0.0, 0.0, Math.toRadians(pitch));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 1.0, 0.0, Math.toRadians(yaw)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 0.0, 1.0, Math.toRadians(roll)));
        return input;
    }

    public static final double[] getRotationMatrix(double ux, double uy, double uz, double angle) {
        if (ux == 0.0 && uy == 0.0 && uz == 0.0) {
            return RotationMatrices.getDoubleIdentity();
        }
        double C = Math.cos(angle);
        double S = Math.sin(angle);
        double t = 1.0 - C;
        double axismag = Math.sqrt(ux * ux + uy * uy + uz * uz);
        double[] matrix = RotationMatrices.getDoubleIdentity();
        matrix[0] = t * (ux /= axismag) * ux + C;
        matrix[1] = t * ux * (uy /= axismag) - S * (uz /= axismag);
        matrix[2] = t * ux * uz + S * uy;
        matrix[4] = t * ux * uy + S * uz;
        matrix[5] = t * uy * uy + C;
        matrix[6] = t * uy * uz - S * ux;
        matrix[8] = t * ux * uz - S * uy;
        matrix[9] = t * uy * uz + S * ux;
        matrix[10] = t * uz * uz + C;
        return matrix;
    }

    public static final double[] getDoubleIdentity() {
        return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    }

    public static final double[] getDoubleIdentity(int size) {
        double[] identity = new double[size * size];
        for (int i = 0; i < identity.length; i += size + 1) {
            identity[i] = 1.0;
            for (int j = i + 1; j < i + size + 1 && j < identity.length; ++j) {
                identity[j] = 0.0;
            }
        }
        return identity;
    }

    public static final double[] getZeroMatrix(int size) {
        double[] zero = new double[size * size];
        for (int i = 0; i < zero.length; ++i) {
            zero[i] = 0.0;
        }
        return zero;
    }

    public static final double[] getMatrixProduct(double[] M1, double[] M2) {
        double[] product = new double[]{M1[0] * M2[0] + M1[1] * M2[4] + M1[2] * M2[8] + M1[3] * M2[12], M1[0] * M2[1] + M1[1] * M2[5] + M1[2] * M2[9] + M1[3] * M2[13], M1[0] * M2[2] + M1[1] * M2[6] + M1[2] * M2[10] + M1[3] * M2[14], M1[0] * M2[3] + M1[1] * M2[7] + M1[2] * M2[11] + M1[3] * M2[15], M1[4] * M2[0] + M1[5] * M2[4] + M1[6] * M2[8] + M1[7] * M2[12], M1[4] * M2[1] + M1[5] * M2[5] + M1[6] * M2[9] + M1[7] * M2[13], M1[4] * M2[2] + M1[5] * M2[6] + M1[6] * M2[10] + M1[7] * M2[14], M1[4] * M2[3] + M1[5] * M2[7] + M1[6] * M2[11] + M1[7] * M2[15], M1[8] * M2[0] + M1[9] * M2[4] + M1[10] * M2[8] + M1[11] * M2[12], M1[8] * M2[1] + M1[9] * M2[5] + M1[10] * M2[9] + M1[11] * M2[13], M1[8] * M2[2] + M1[9] * M2[6] + M1[10] * M2[10] + M1[11] * M2[14], M1[8] * M2[3] + M1[9] * M2[7] + M1[10] * M2[11] + M1[11] * M2[15], M1[12] * M2[0] + M1[13] * M2[4] + M1[14] * M2[8] + M1[15] * M2[12], M1[12] * M2[1] + M1[13] * M2[5] + M1[14] * M2[9] + M1[15] * M2[13], M1[12] * M2[2] + M1[13] * M2[6] + M1[14] * M2[10] + M1[15] * M2[14], M1[12] * M2[3] + M1[13] * M2[7] + M1[14] * M2[11] + M1[15] * M2[15]};
        return product;
    }

    public static final void applyTransform(double[] M, Vector vec) {
        double x = vec.X;
        double y = vec.Y;
        double z = vec.Z;
        vec.X = x * M[0] + y * M[1] + z * M[2] + M[3];
        vec.Y = x * M[4] + y * M[5] + z * M[6] + M[7];
        vec.Z = x * M[8] + y * M[9] + z * M[10] + M[11];
    }

    @Deprecated
    public static final void applyTransform(double[] wholeTransform, double[] rotationTransform, Entity ent) {
        EntityFireball ball;
        Vector entityPos = new Vector(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        Vector entityLook = new Vector(ent.func_70676_i(1.0f));
        Vector entityMotion = new Vector(ent.field_70159_w, ent.field_70181_x, ent.field_70179_y);
        if (ent instanceof EntityFireball) {
            ball = (EntityFireball)ent;
            entityMotion.X = ball.field_70232_b;
            entityMotion.Y = ball.field_70233_c;
            entityMotion.Z = ball.field_70230_d;
        }
        RotationMatrices.applyTransform(wholeTransform, entityPos);
        RotationMatrices.doRotationOnly(rotationTransform, entityLook);
        RotationMatrices.doRotationOnly(rotationTransform, entityMotion);
        entityLook.normalize();
        ent.field_70127_C = ent.field_70125_A = (float)MathHelper.func_76138_g((double)BigBastardMath.getPitchFromVec3d(entityLook));
        ent.field_70126_B = ent.field_70177_z = (float)MathHelper.func_76138_g((double)BigBastardMath.getYawFromVec3d(entityLook, ent.field_70125_A));
        if (ent instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)ent;
            living.field_70759_as = ent.field_70177_z;
            living.field_70758_at = ent.field_70177_z;
        }
        if (ent instanceof EntityFireball) {
            ball = (EntityFireball)ent;
            ball.field_70232_b = entityMotion.X;
            ball.field_70233_c = entityMotion.Y;
            ball.field_70230_d = entityMotion.Z;
        }
        ent.field_70159_w = entityMotion.X;
        ent.field_70181_x = entityMotion.Y;
        ent.field_70179_y = entityMotion.Z;
        ent.func_70107_b(entityPos.X, entityPos.Y, entityPos.Z);
    }

    public static final BlockPos applyTransform(double[] M, BlockPos pos) {
        Vector blockPosVec = new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        RotationMatrices.applyTransform(M, blockPosVec);
        BlockPos newPos = new BlockPos((double)Math.round(blockPosVec.X - 0.5), (double)Math.round(blockPosVec.Y - 0.5), (double)Math.round(blockPosVec.Z - 0.5));
        return newPos;
    }

    public static final Vec3d applyTransform(double[] M, Vec3d vec) {
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        return new Vec3d(x * M[0] + y * M[1] + z * M[2] + M[3], x * M[4] + y * M[5] + z * M[6] + M[7], x * M[8] + y * M[9] + z * M[10] + M[11]);
    }

    public static final void applyTransform3by3(double[] M, Vector vec) {
        double xx = vec.X;
        double yy = vec.Y;
        double zz = vec.Z;
        vec.X = xx * M[0] + yy * M[1] + zz * M[2];
        vec.Y = xx * M[3] + yy * M[4] + zz * M[5];
        vec.Z = xx * M[6] + yy * M[7] + zz * M[8];
    }

    public static final void doRotationOnly(double[] M, Vector vec) {
        double x = vec.X;
        double y = vec.Y;
        double z = vec.Z;
        vec.X = x * M[0] + y * M[1] + z * M[2];
        vec.Y = x * M[4] + y * M[5] + z * M[6];
        vec.Z = x * M[8] + y * M[9] + z * M[10];
    }

    public static final float[] convertToFloat(double[] array) {
        float[] floatArray = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            floatArray[i] = (float)array[i];
        }
        return floatArray;
    }

    public static final double[] convertToDouble(float[] array) {
        double[] doubleArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            doubleArray[i] = array[i];
        }
        return doubleArray;
    }

    public static final Vector get3by3TransformedVec(double[] M, Vector v) {
        Vector vec = new Vector(v);
        RotationMatrices.applyTransform3by3(M, vec);
        return vec;
    }

    public static final Vector getTransformedVec(double[] M, Vector v) {
        Vector vec = new Vector(v);
        RotationMatrices.applyTransform(M, vec);
        return vec;
    }

    public static final double[] inverse3by3(double[] matrix) {
        double[] inverse = new double[9];
        inverse[0] = matrix[4] * matrix[8] - matrix[5] * matrix[7];
        inverse[3] = matrix[5] * matrix[6] - matrix[3] * matrix[8];
        inverse[6] = matrix[3] * matrix[7] - matrix[4] * matrix[6];
        inverse[1] = matrix[2] * matrix[6] - matrix[1] * matrix[8];
        inverse[4] = matrix[0] * matrix[8] - matrix[2] * matrix[6];
        inverse[7] = matrix[6] * matrix[1] - matrix[0] * matrix[7];
        inverse[2] = matrix[1] * matrix[5] - matrix[2] * matrix[4];
        inverse[5] = matrix[2] * matrix[3] - matrix[0] * matrix[5];
        inverse[8] = matrix[0] * matrix[4] - matrix[1] * matrix[3];
        double det = matrix[0] * inverse[0] + matrix[1] * inverse[3] + matrix[2] * inverse[6];
        int i = 0;
        while (i < 9) {
            int n = i++;
            inverse[n] = inverse[n] / det;
        }
        return inverse;
    }

    public static final double[] inverse(double[] matrix) {
        double[] inverse = new double[16];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                inverse[i * 4 + j] = matrix[i + j * 4];
            }
            inverse[i * 4 + 3] = -inverse[i * 4] * matrix[3] - inverse[i * 4 + 1] * matrix[7] - inverse[i * 4 + 2] * matrix[11];
        }
        inverse[12] = 0.0;
        inverse[13] = 0.0;
        inverse[14] = 0.0;
        inverse[15] = 1.0;
        return inverse;
    }
}

