/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.api;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import valkyrienwarfare.api.RotationMatrices;

public class Vector {
    public double X;
    public double Y;
    public double Z;

    public Vector(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector(double x, double y, double z, double[] rotationMatrix) {
        this.X = x;
        this.Y = y;
        this.Z = z;
        RotationMatrices.applyTransform(rotationMatrix, this);
    }

    public Vector(Vector v) {
        this.X = v.X;
        this.Y = v.Y;
        this.Z = v.Z;
    }

    public Vector(Vector v, double scale) {
        this.X = v.X * scale;
        this.Y = v.Y * scale;
        this.Z = v.Z * scale;
    }

    public Vector(Vec3d positionVector) {
        this.X = positionVector.field_72450_a;
        this.Y = positionVector.field_72448_b;
        this.Z = positionVector.field_72449_c;
    }

    public Vector(Entity entity) {
        this.X = entity.field_70165_t;
        this.Y = entity.field_70163_u;
        this.Z = entity.field_70161_v;
    }

    public Vector() {
        this.Z = 0.0;
        this.Y = 0.0;
        this.X = 0.0;
    }

    public Vector(ByteBuf toRead) {
        this(toRead.readDouble(), toRead.readDouble(), toRead.readDouble());
    }

    public Vector(Vector theNormal, double[] matrixTransform) {
        this(theNormal.X, theNormal.Y, theNormal.Z, matrixTransform);
    }

    public static Vector[] generateAxisAlignedNorms() {
        Vector[] norms = new Vector[]{new Vector(1.0, 0.0, 0.0), new Vector(0.0, 1.0, 0.0), new Vector(0.0, 0.0, 1.0)};
        return norms;
    }

    public Vector getSubtraction(Vector v) {
        return new Vector(v.X - this.X, v.Y - this.Y, v.Z - this.Z);
    }

    public Vector getAddition(Vector v) {
        return new Vector(v.X + this.X, v.Y + this.Y, v.Z + this.Z);
    }

    public void subtract(Vector v) {
        this.X -= v.X;
        this.Y -= v.Y;
        this.Z -= v.Z;
    }

    public void subtract(double x, double y, double z) {
        this.X -= x;
        this.Y -= y;
        this.Z -= z;
    }

    public void subtract(Vec3d vec) {
        this.X -= vec.field_72450_a;
        this.Y -= vec.field_72448_b;
        this.Z -= vec.field_72449_c;
    }

    public final void add(Vector v) {
        this.X += v.X;
        this.Y += v.Y;
        this.Z += v.Z;
    }

    public final void add(double x, double y, double z) {
        this.X += x;
        this.Y += y;
        this.Z += z;
    }

    public void add(Vec3d vec) {
        this.X += vec.field_72450_a;
        this.Y += vec.field_72448_b;
        this.Z += vec.field_72449_c;
    }

    public double dot(Vector v) {
        return this.X * v.X + this.Y * v.Y + this.Z * v.Z;
    }

    public Vector cross(Vector v) {
        return new Vector(this.Y * v.Z - v.Y * this.Z, this.Z * v.X - this.X * v.Z, this.X * v.Y - v.X * this.Y);
    }

    public Vector upCross(Vector v) {
        return new Vector(-v.Y * this.Z, 0.0, this.X * v.Y);
    }

    public final void setCross(Vector v1, Vector v) {
        this.X = v1.Y * v.Z - v.Y * v1.Z;
        this.Y = v1.Z * v.X - v1.X * v.Z;
        this.Z = v1.X * v.Y - v.X * v1.Y;
    }

    public void multiply(double scale) {
        this.X *= scale;
        this.Y *= scale;
        this.Z *= scale;
    }

    public Vector getProduct(double scale) {
        return new Vector(this.X * scale, this.Y * scale, this.Z * scale);
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.X, this.Y, this.Z);
    }

    public void normalize() {
        double d = MathHelper.func_76133_a((double)(this.X * this.X + this.Y * this.Y + this.Z * this.Z));
        if (d < 1.0E-6) {
            this.X = 0.0;
            this.Y = 0.0;
            this.Z = 0.0;
        } else {
            this.X /= d;
            this.Y /= d;
            this.Z /= d;
        }
    }

    public double length() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public double lengthSq() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z;
    }

    public boolean isZero() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z < 1.0E-12;
    }

    public void zero() {
        this.Z = 0.0;
        this.Y = 0.0;
        this.X = 0.0;
    }

    public void roundToWhole() {
        this.X = Math.round(this.X);
        this.Y = Math.round(this.Y);
        this.Z = Math.round(this.Z);
    }

    public boolean equals(Vector vec) {
        return vec.X == this.X && vec.Y == this.Y && vec.Z == this.Z;
    }

    public String toString() {
        String coords = new String("<" + this.X + ", " + this.Y + ", " + this.Z + ">");
        return coords;
    }

    public String toRoundedString() {
        String coords = new String("<" + (double)Math.round(this.X * 100.0) / 100.0 + ", " + (double)Math.round(this.Y * 100.0) / 100.0 + ", " + (double)Math.round(this.Z * 100.0) / 100.0 + ">");
        return coords;
    }

    public Vector crossAndUnit(Vector v) {
        Vector crossProduct = new Vector(this.Y * v.Z - v.Y * this.Z, this.Z * v.X - this.X * v.Z, this.X * v.Y - v.X * this.Y);
        crossProduct.normalize();
        return crossProduct;
    }

    public void writeToByteBuf(ByteBuf toWrite) {
        toWrite.writeDouble(this.X);
        toWrite.writeDouble(this.Y);
        toWrite.writeDouble(this.Z);
    }

    public void setSubtraction(Vector inLocal, Vector centerCoord) {
        this.X = inLocal.X - centerCoord.X;
        this.Y = inLocal.Y - centerCoord.Y;
        this.Z = inLocal.Z - centerCoord.Z;
    }

    public void transform(double[] rotationMatrix) {
        RotationMatrices.applyTransform(rotationMatrix, this);
    }
}

