/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.api.addons;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.addons.ModuleProxy;

public abstract class Module<ImplName> {
    private String name;
    private boolean donePreInit = false;
    private boolean doneInit = false;
    private boolean donePostInit = false;
    private ModuleProxy common;
    private ModuleProxy client;
    private ModuleProxy server;
    private String modid;

    public Module(String name, ModuleProxy common, ModuleProxy client, ModuleProxy server) {
        this(name, common, "valkyrienwarfare");
    }

    public Module(String name, ModuleProxy common, String modid) {
        this.name = name;
        this.common = common;
        this.modid = modid;
    }

    public final void setServerProxy(ModuleProxy server) {
        this.server = server;
    }

    public final void setClientProxy(ModuleProxy client) {
        this.client = client;
    }

    public final void doPreInit(FMLStateEvent event) {
        if (!this.donePreInit) {
            this.setupConfig();
            this.registerBlocks();
            this.registerItems();
            this.registerEntities();
            this.registerCapabilities();
            this.preInit(event);
            this.donePreInit = true;
        }
    }

    public final void doInit(FMLStateEvent event) {
        if (!this.doneInit) {
            this.registerTileEntities();
            this.registerRecipes();
            this.registerNetworks();
            this.init(event);
            this.doneInit = true;
        }
    }

    public final void doPostInit(FMLStateEvent event) {
        if (!this.donePostInit) {
            this.postInit(event);
            this.donePostInit = true;
        }
    }

    protected void setupConfig() {
    }

    protected void registerItems() {
    }

    protected void registerBlocks() {
    }

    protected void registerRecipes() {
    }

    protected void registerEntities() {
    }

    protected void registerTileEntities() {
    }

    protected void registerNetworks() {
    }

    protected void registerCapabilities() {
    }

    public final ModuleProxy getClientProxy() {
        return this.client;
    }

    public final ModuleProxy getServerProxy() {
        return this.server;
    }

    public final ModuleProxy getCommonProxy() {
        return this.common;
    }

    protected abstract void preInit(FMLStateEvent var1);

    protected abstract void init(FMLStateEvent var1);

    protected abstract void postInit(FMLStateEvent var1);

    protected final void registerBlock(Block b) {
        ValkyrienWarfareMod.registerBlock(b);
    }

    protected final void registerItem(Item i) {
        GameRegistry.register((IForgeRegistryEntry)i);
    }

    public final String getModID() {
        return this.modid;
    }
}

